/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.requirement;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.requirement.RequirementMatch;
import java.util.HashMap;
import java.util.Map;

public class RequirementsResult<SENDER> {
    private final Invocation<SENDER> invocation;
    private final Map<String, RequirementMatch> matches;

    private RequirementsResult(Invocation<SENDER> invocation, Map<String, RequirementMatch> matches) {
        this.invocation = invocation;
        this.matches = matches;
    }

    public boolean has(String name) {
        return this.matches.containsKey(name);
    }

    public RequirementMatch get(String name) {
        return this.matches.get(name);
    }

    public Invocation<SENDER> getInvocation() {
        return this.invocation;
    }

    public static <SENDER> Builder<SENDER> builder(Invocation<SENDER> invocation) {
        return new Builder<SENDER>(invocation);
    }

    public static class Builder<SENDER> {
        private final Invocation<SENDER> invocation;
        private final Map<String, RequirementMatch> matches = new HashMap<String, RequirementMatch>();

        public Builder(Invocation<SENDER> invocation) {
            this.invocation = invocation;
        }

        public Builder<SENDER> add(String name, RequirementMatch match) {
            RequirementMatch replacedMatch = this.matches.put(name, match);
            if (replacedMatch != null) {
                throw new IllegalStateException("Requirement match already exists: " + name);
            }
            return this;
        }

        public RequirementsResult<SENDER> build() {
            return new RequirementsResult(this.invocation, this.matches);
        }
    }
}

