/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.input.raw;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.input.raw.RawInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

class RawInputImpl
implements RawInput {
    private final List<String> rawArgumentsToConsume;
    private int consumed = 0;

    RawInputImpl(List<String> rawArgumentsToConsume) {
        this.rawArgumentsToConsume = rawArgumentsToConsume;
    }

    @Override
    public boolean hasNext() {
        return !this.rawArgumentsToConsume.isEmpty();
    }

    @Override
    public String next() {
        if (this.rawArgumentsToConsume.isEmpty()) {
            throw new NoSuchElementException("No more arguments to consume, consumed: " + this.consumed);
        }
        ++this.consumed;
        return this.rawArgumentsToConsume.remove(0);
    }

    @Override
    public List<String> next(int count) {
        if (count > this.rawArgumentsToConsume.size()) {
            throw new IllegalArgumentException("Cannot consume next " + count + " arguments, only " + this.rawArgumentsToConsume.size() + " left");
        }
        if (count == 0) {
            return Collections.emptyList();
        }
        this.consumed += count;
        List<String> sourceView = this.rawArgumentsToConsume.subList(0, count);
        ArrayList<String> copyView = new ArrayList<String>(sourceView);
        sourceView.clear();
        return copyView;
    }

    @Override
    public List<String> nextAll() {
        ArrayList<String> copy = new ArrayList<String>(this.rawArgumentsToConsume);
        this.rawArgumentsToConsume.clear();
        this.consumed += copy.size();
        return copy;
    }

    @Override
    public String seeNext() {
        if (this.rawArgumentsToConsume.isEmpty()) {
            throw new NoSuchElementException("No more arguments to consume, consumed: " + this.consumed);
        }
        return this.rawArgumentsToConsume.get(0);
    }

    @Override
    public List<String> seeNext(int count) {
        if (count > this.rawArgumentsToConsume.size()) {
            throw new IllegalArgumentException("Cannot see next " + count + " arguments, only " + this.rawArgumentsToConsume.size() + " left");
        }
        return this.rawArgumentsToConsume.subList(0, count);
    }

    @Override
    public List<String> seeAll() {
        return this.seeNext(this.rawArgumentsToConsume.size());
    }

    @Override
    public int size() {
        return this.rawArgumentsToConsume.size();
    }

    @Override
    public int consumedCount() {
        return this.consumed;
    }
}

