/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.cooldown;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.cooldown.CooldownContext;
import java.time.Duration;
import java.time.Instant;

public class CooldownState {
    private final String key;
    private final Duration duration;
    private final Instant expirationTime;

    public CooldownState(String key, Duration duration) {
        this.key = key;
        this.duration = duration;
        this.expirationTime = Instant.now().plus(duration);
    }

    public String getKey() {
        return this.key;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Duration getRemainingDuration() {
        return Duration.between(Instant.now(), this.expirationTime);
    }

    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isExpired() {
        return Instant.now().isAfter(this.expirationTime);
    }

    @Deprecated
    public CooldownContext getCooldownContext() {
        return new CooldownContext(this.key, this.duration);
    }
}

