/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.resolver.optional;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.Parser;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParserChainAccessor;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParserRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.resolver.MultipleArgumentResolverChained;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.suggester.SuggesterChainAccessor;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.input.raw.RawInput;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.range.Range;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.reflect.type.TypeToken;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import java.util.Optional;

public class OptionalArgumentResolver<SENDER>
implements MultipleArgumentResolverChained<SENDER, Optional> {
    private final ParserRegistry<SENDER> parserRegistry;

    public OptionalArgumentResolver(ParserRegistry<SENDER> parserRegistry) {
        this.parserRegistry = parserRegistry;
    }

    @Override
    public ParseResult<Optional> parse(Invocation<SENDER> invocation, Argument<Optional> optionalArgument, RawInput input, ParserChainAccessor<SENDER> chainAccessor) {
        TypeToken optionalType = optionalArgument.getType();
        TypeToken<?> parameterized = optionalType.getParameterized();
        return this.parseValue(parameterized, invocation, optionalArgument, input, chainAccessor);
    }

    private <E> ParseResult<Optional> parseValue(TypeToken<E> type, Invocation<SENDER> invocation, Argument<Optional> optionalArgument, RawInput input, ParserChainAccessor<SENDER> chainAccessor) {
        Argument<E> argument = optionalArgument.child(type);
        ParseResult<E> parseResult = chainAccessor.parse(invocation, argument.child(type), input);
        return parseResult.map(value -> Optional.of(value)).mapFailure(failure -> failure == InvalidUsage.Cause.MISSING_ARGUMENT ? ParseResult.success(Optional.empty()) : ParseResult.failure(failure));
    }

    @Override
    public Range getRange(Argument<Optional> optionalArgument) {
        TypeToken optionalType = optionalArgument.getType();
        return this.getRange(optionalType.getParameterized(), optionalArgument);
    }

    private <T> Range getRange(TypeToken<T> parameterized, Argument<Optional> optionalArgument) {
        Argument<T> argument = optionalArgument.child(parameterized);
        Parser<SENDER, T> parser = this.parserRegistry.getParser(argument);
        Range range = parser.getRange(argument);
        return Range.range(0, range.getMax());
    }

    @Override
    public SuggestionResult suggest(Invocation<SENDER> invocation, Argument<Optional> argument, SuggestionContext context, SuggesterChainAccessor<SENDER> chainAccessor) {
        TypeToken optionalType = argument.getType();
        TypeToken<?> parameterized = optionalType.getParameterized();
        return chainAccessor.suggest(invocation, argument.child(parameterized), context);
    }
}

