/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.resolver.nullable;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.Parser;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.parser.ParserRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.profile.ProfileNamespaces;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.profile.ProfiledMultipleArgumentResolver;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.resolver.nullable.NullableProfile;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.suggester.Suggester;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.argument.suggester.SuggesterRegistry;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.input.raw.RawInput;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.range.Range;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.reflect.type.TypeToken;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;

public class NullableArgumentResolver<SENDER>
extends ProfiledMultipleArgumentResolver<SENDER, Object, NullableProfile> {
    private final ParserRegistry<SENDER> parserRegistry;
    private final SuggesterRegistry<SENDER> suggesterRegistry;

    public NullableArgumentResolver(ParserRegistry<SENDER> parserRegistry, SuggesterRegistry<SENDER> suggesterRegistry) {
        super(NullableProfile.NAMESPACE);
        this.parserRegistry = parserRegistry;
        this.suggesterRegistry = suggesterRegistry;
    }

    @Override
    protected ParseResult<Object> parse(Invocation<SENDER> invocation, Argument<Object> argument, RawInput rawInput, NullableProfile unused) {
        return this.parseValue(invocation, argument, rawInput);
    }

    private <E> ParseResult<E> parseValue(Invocation<SENDER> invocation, Argument<E> optionalArgument, RawInput input) {
        Argument<E> argument = optionalArgument.withoutProfile(ProfileNamespaces.NULLABLE);
        Parser<SENDER, E> parser = this.parserRegistry.getParser(argument);
        ParseResult<E> parseResult = parser.parse(invocation, argument, input);
        return parseResult.mapFailure(failure -> failure == InvalidUsage.Cause.MISSING_ARGUMENT ? ParseResult.successNull() : ParseResult.failure(failure));
    }

    @Override
    protected SuggestionResult suggest(Invocation<SENDER> invocation, Argument<Object> argument, SuggestionContext context, NullableProfile nullableProfile) {
        TypeToken type = argument.getType();
        Suggester<SENDER, Object> suggester = this.suggesterRegistry.getSuggester(type.getRawType(), argument.getKey().withDefaultNamespace());
        return suggester.suggest(invocation, argument, context);
    }

    @Override
    protected Range getRange(Argument<Object> argument, NullableProfile unused) {
        return this.getRangeTyped(argument);
    }

    private <T> Range getRangeTyped(Argument<T> optionalArgument) {
        Argument<T> argument = optionalArgument.withoutProfile(ProfileNamespaces.NULLABLE);
        Parser<SENDER, T> parser = this.parserRegistry.getParser(argument);
        Range range = parser.getRange(argument);
        return Range.range(0, range.getMax());
    }
}

