/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.AnnotationInvoker;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.AnnotationProcessor;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.AnnotationProcessorService;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.MethodCommandExecutor;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.MethodDefinition;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.ParameterInvoker;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.meta.MetaAnnotationKeys;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.annotations.validator.method.MethodValidatorService;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.CommandExecutorProvider;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.builder.CommandBuilder;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.meta.Meta;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.meta.MetaHolder;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.reflect.LiteCommandsReflectInvocationException;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.requirement.Requirement;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class MethodInvoker<SENDER>
implements AnnotationInvoker<SENDER>,
MetaHolder {
    private final AnnotationProcessorService<SENDER> annotationProcessorService;
    private final Method method;
    private final CommandBuilder<SENDER> commandBuilder;
    private final MethodDefinition methodDefinition;
    private final CommandExecutorProvider<SENDER> executorProvider;
    private final Meta meta = Meta.create();
    private boolean isExecutorStructure = false;

    public MethodInvoker(AnnotationProcessorService<SENDER> annotationProcessorService, MethodValidatorService<SENDER> validatorService, Object instance, Method method, CommandBuilder<SENDER> commandBuilder) {
        this.annotationProcessorService = annotationProcessorService;
        this.method = method;
        this.commandBuilder = commandBuilder;
        this.methodDefinition = new MethodDefinition(method);
        this.executorProvider = parent -> new MethodCommandExecutor(parent, method, instance, this.methodDefinition, this.meta, validatorService);
    }

    @Override
    public <A extends Annotation> AnnotationInvoker<SENDER> on(Class<A> annotationType, AnnotationProcessor.AnyListener<A> listener) {
        A annotation = this.method.getAnnotation(annotationType);
        if (annotation == null) {
            return this;
        }
        listener.call(annotation, this);
        return this;
    }

    @Override
    public <A extends Annotation> AnnotationInvoker<SENDER> onMethod(Class<A> annotationType, AnnotationProcessor.MethodListener<SENDER, A> listener) {
        A methodAnnotation = this.method.getAnnotation(annotationType);
        if (methodAnnotation == null) {
            return this;
        }
        listener.call(this.method, methodAnnotation, this.commandBuilder, this.executorProvider);
        this.isExecutorStructure = true;
        return this;
    }

    @Override
    public <A extends Annotation> AnnotationInvoker<SENDER> onParameter(Class<A> annotationType, AnnotationProcessor.ParameterListener<SENDER, A> listener) {
        for (int index = 0; index < this.method.getParameterCount(); ++index) {
            Parameter parameter = this.method.getParameters()[index];
            A parameterAnnotation = parameter.getAnnotation(annotationType);
            if (parameterAnnotation == null || this.methodDefinition.hasRequirement(index)) continue;
            Optional<Requirement<?>> requirementOptional = listener.call(parameter, parameterAnnotation, this.commandBuilder);
            this.registerRequirement(index, parameter, (Annotation)parameterAnnotation, requirementOptional);
        }
        return this;
    }

    @ApiStatus.Experimental
    public MethodInvoker<SENDER> mapParameter(BiFunction<Parameter, Annotation, Optional<Requirement<?>>> provider) {
        for (int index = 0; index < this.method.getParameterCount(); ++index) {
            Parameter parameter = this.method.getParameters()[index];
            for (Annotation annotation : parameter.getAnnotations()) {
                Optional<Requirement<?>> requirementOptional = provider.apply(parameter, annotation);
                this.registerRequirement(index, parameter, annotation, requirementOptional);
            }
        }
        return this;
    }

    private void registerRequirement(int index, Parameter parameter, Annotation annotation, Optional<Requirement<?>> requirementOptional) {
        if (requirementOptional.isPresent()) {
            Requirement<?> requirement = requirementOptional.get();
            requirement.meta().put(MetaAnnotationKeys.SOURCE_PARAMETER, parameter).put(MetaAnnotationKeys.SOURCE_ANNOTATION, annotation).put(MetaAnnotationKeys.SOURCE_ANNOTATED_ELEMENT, parameter);
            this.methodDefinition.putRequirement(index, requirement);
            this.annotationProcessorService.process(new ParameterInvoker<SENDER>(this.commandBuilder, parameter, requirement));
        }
    }

    @ApiStatus.Experimental
    public Method getMethod() {
        return this.method;
    }

    @Override
    public CommandBuilder<SENDER> getResult() {
        if (!this.isExecutorStructure) {
            return this.commandBuilder;
        }
        Parameter[] parameters = this.method.getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            if (this.methodDefinition.hasRequirement(index)) continue;
            Parameter parameter = parameters[index];
            throw new LiteCommandsReflectInvocationException((Executable)this.method, parameter, "Parameter '" + parameter.getName() + "' needs @Arg, @Flag, @Join, @Context or @Bind annotation for define requirement!");
        }
        return this.commandBuilder;
    }

    @Override
    public Meta meta() {
        return this.meta;
    }

    @Override
    @Nullable
    public MetaHolder parentMeta() {
        return this.commandBuilder;
    }
}

