/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.com.eternalcode.commons.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class BatchProcessor<T> {
    private final List<T> elements;
    private final int batchSize;
    private int position;

    public BatchProcessor(Collection<T> elements, int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("Batch size must be greater than 0");
        }
        this.elements = new ArrayList<T>(elements);
        this.batchSize = batchSize;
        this.position = 0;
    }

    public boolean processNext(Consumer<T> processor) {
        if (this.position >= this.elements.size()) {
            return false;
        }
        int endPosition = Math.min(this.position + this.batchSize, this.elements.size());
        List<T> currentBatch = this.elements.subList(this.position, endPosition);
        currentBatch.forEach(processor);
        this.position = endPosition;
        return this.position < this.elements.size();
    }

    public void reset() {
        this.position = 0;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getPosition() {
        return this.position;
    }

    public int getTotalSize() {
        return this.elements.size();
    }

    public boolean isComplete() {
        return this.position >= this.elements.size();
    }

    public int getRemainingCount() {
        return Math.max(0, this.elements.size() - this.position);
    }

    public int getProcessedBatchCount() {
        return (this.position + this.batchSize - 1) / this.batchSize;
    }

    public int getTotalBatchCount() {
        return (this.elements.size() + this.batchSize - 1) / this.batchSize;
    }

    public double getProgress() {
        if (this.elements.isEmpty()) {
            return 1.0;
        }
        return (double)this.position / (double)this.elements.size();
    }
}

