/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.fight.logout;

import com.eternalcode.combat.fight.logout.Logout;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;

public class LogoutService {
    private final Cache<UUID, Logout> logouts = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public void punishForLogout(Player player) {
        UUID uniqueId = player.getUniqueId();
        this.logouts.put((Object)uniqueId, (Object)new Logout(uniqueId, player.getHealth()));
    }

    public Optional<Logout> nextLogoutFor(UUID player) {
        Logout logout = (Logout)this.logouts.getIfPresent((Object)player);
        if (logout == null) {
            return Optional.empty();
        }
        this.logouts.invalidate((Object)player);
        return Optional.of(logout);
    }

    public boolean hasLoggedOut(UUID player) {
        return this.logouts.asMap().containsKey(player);
    }
}

