/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.fight.controller;

import com.eternalcode.combat.WhitelistBlacklistMode;
import com.eternalcode.combat.config.implementation.PluginConfig;
import com.eternalcode.combat.fight.FightManager;
import com.eternalcode.combat.fight.event.CauseOfTag;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class FightTagController
implements Listener {
    private final FightManager fightManager;
    private final PluginConfig config;

    public FightTagController(FightManager fightManager, PluginConfig config) {
        this.fightManager = fightManager;
        this.config = config;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Projectile projectile;
        if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.THORNS)) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attackedPlayerByPerson = (Player)entity;
        List<EntityType> disabledProjectileEntities = this.config.combat.ignoredProjectileTypes;
        Entity entity2 = event.getDamager();
        if (entity2 instanceof Projectile && disabledProjectileEntities.contains((projectile = (Projectile)entity2).getType())) {
            return;
        }
        if (this.isPlayerInDisabledWorld(attackedPlayerByPerson)) {
            return;
        }
        Player attacker = this.getDamager(event);
        if (attacker == null) {
            return;
        }
        if (this.config.combat.disableFlying) {
            if (attackedPlayerByPerson.isFlying()) {
                attackedPlayerByPerson.setFlying(false);
                attackedPlayerByPerson.setAllowFlight(false);
            }
            if (attacker.isFlying()) {
                attacker.setFlying(false);
                attacker.setAllowFlight(false);
            }
        }
        Duration combatTime = this.config.settings.combatTimerDuration;
        UUID attackedUniqueId = attackedPlayerByPerson.getUniqueId();
        UUID attackerUniqueId = attacker.getUniqueId();
        this.fightManager.tag(attackedUniqueId, combatTime, CauseOfTag.PLAYER, attackerUniqueId);
        this.fightManager.tag(attackerUniqueId, combatTime, CauseOfTag.PLAYER, attackedUniqueId);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    void onEntityDamage(EntityDamageEvent event) {
        if (!this.config.combat.enableDamageCauseLogging) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isPlayerInDisabledWorld(player)) {
            return;
        }
        Duration combatTime = this.config.settings.combatTimerDuration;
        UUID uuid = player.getUniqueId();
        WhitelistBlacklistMode mode = this.config.combat.damageCauseRestrictionMode;
        List<EntityDamageEvent.DamageCause> damageCauses = this.config.combat.loggedDamageCauses;
        EntityDamageEvent.DamageCause cause = event.getCause();
        boolean shouldLog = mode.shouldBlock(damageCauses.contains(cause));
        if (shouldLog) {
            return;
        }
        this.fightManager.tag(uuid, combatTime, CauseOfTag.NON_PLAYER);
    }

    @Nullable
    Player getDamager(EntityDamageByEntityEvent event) {
        Projectile projectile;
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player damager = (Player)entity;
            return damager;
        }
        Entity entity2 = event.getDamager();
        if (entity2 instanceof Projectile && (entity2 = (projectile = (Projectile)entity2).getShooter()) instanceof Player) {
            Player shooter = (Player)entity2;
            return shooter;
        }
        return null;
    }

    private boolean isPlayerInDisabledWorld(Player player) {
        String worldName = player.getWorld().getName();
        return this.config.settings.ignoredWorlds.contains(worldName);
    }
}

