/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.crystalpvp;

import com.eternalcode.combat.config.implementation.PluginConfig;
import com.eternalcode.combat.crystalpvp.CrystalMetadata;
import com.eternalcode.combat.crystalpvp.CrystalPvpConstants;
import com.eternalcode.combat.fight.FightManager;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class RespawnAnchorListener
implements Listener {
    private final Plugin plugin;
    private final FightManager fightManager;
    private final PluginConfig pluginConfig;

    public RespawnAnchorListener(Plugin plugin, FightManager fightManager, PluginConfig pluginConfig) {
        this.plugin = plugin;
        this.fightManager = fightManager;
        this.pluginConfig = pluginConfig;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    void onAnchorInteract(PlayerInteractEvent event) {
        boolean isGlowstone;
        Block block = event.getClickedBlock();
        if (block == null || block.getType() != Material.RESPAWN_ANCHOR) {
            return;
        }
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof RespawnAnchor)) {
            return;
        }
        RespawnAnchor respawnAnchor = (RespawnAnchor)blockData;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        int charges = respawnAnchor.getCharges();
        ItemStack item = event.getItem();
        boolean bl = isGlowstone = item != null && item.getType() == Material.GLOWSTONE;
        if (charges > 0 && !isGlowstone || charges == respawnAnchor.getMaximumCharges()) {
            this.addMetaData(event, block);
        }
    }

    private void addMetaData(PlayerInteractEvent event, Block block) {
        block.setMetadata("eternalcombat:anchor", (MetadataValue)new CrystalMetadata(this.plugin, event.getPlayer().getUniqueId()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    void onAnchorExplosion(EntityDamageByBlockEvent event) {
        if (!this.pluginConfig.crystalPvp.tagFromRespawnAnchor) {
            return;
        }
        if (this.pluginConfig.settings.ignoredWorlds.contains(event.getEntity().getWorld().getName())) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Optional<UUID> optionalDamagerUniqueId = CrystalPvpConstants.getDamagerUniqueIdFromRespawnAnchor(event);
        if (optionalDamagerUniqueId.isEmpty()) {
            return;
        }
        CrystalPvpConstants.handleCombatTag(optionalDamagerUniqueId, player, this.fightManager, this.pluginConfig);
    }
}

