/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.border.animation.particle;

import com.eternalcode.combat.border.BorderPoint;
import com.eternalcode.combat.border.animation.particle.ParticleColor;
import com.eternalcode.combat.libs.eu.okaeri.configs.OkaeriConfig;
import com.eternalcode.combat.libs.eu.okaeri.configs.annotation.Comment;
import com.github.retrooper.packetevents.protocol.color.AlphaColor;
import com.github.retrooper.packetevents.protocol.particle.Particle;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleColorData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleDustData;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleType;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerParticle;
import java.awt.Color;

public class ParticleSettings
extends OkaeriConfig {
    @Comment(value={"# Enable particle animation?"})
    public boolean enabled = true;
    @Comment(value={"# Particle type - https://javadocs.packetevents.com/com/github/retrooper/packetevents/protocol/particle/type/ParticleTypes.html"})
    public ParticleType type = ParticleTypes.DUST;
    @Comment(value={"# Particle color (used only for DUST or ENTITY_EFFECT particle type)", "# You can set hex color e.g. \"#ca4c45\" or use \"RAINBOW\" to generate rainbow gradient based on x and z coordinates."})
    public ParticleColor color = ParticleColor.RAINBOW;
    public int count = 1;
    public float scale = 1.7f;
    public float maxSpeed = 0.0f;
    public float offsetX = 0.2f;
    public float offsetY = 0.2f;
    public float offsetZ = 0.2f;

    public WrapperPlayServerParticle getParticle(BorderPoint point) {
        return this.getParticle(point, this.type);
    }

    private <T extends ParticleData> WrapperPlayServerParticle getParticle(BorderPoint point, ParticleType<T> type) {
        T particleData = this.createData(type, point);
        Particle dust = new Particle(type, particleData);
        return new WrapperPlayServerParticle(dust, true, new Vector3d((double)point.x(), (double)point.y(), (double)point.z()), new Vector3f(this.orElse(Float.valueOf(this.offsetX), Float.valueOf(0.1f)).floatValue(), this.orElse(Float.valueOf(this.offsetY), Float.valueOf(0.1f)).floatValue(), this.orElse(Float.valueOf(this.offsetZ), Float.valueOf(0.1f)).floatValue()), this.orElse(Float.valueOf(this.maxSpeed), Float.valueOf(0.0f)).floatValue(), this.count, true);
    }

    private <T> T orElse(T nullable, T or) {
        return nullable != null ? nullable : or;
    }

    private <T extends ParticleData> T createData(ParticleType<T> type, BorderPoint point) {
        if (type.equals((Object)ParticleTypes.DUST)) {
            Color color = this.color.getColor(point);
            return (T)new ParticleDustData(this.orElse(Float.valueOf(this.scale), Float.valueOf(1.0f)).floatValue(), color.getRed(), color.getGreen(), color.getBlue());
        }
        if (type.equals((Object)ParticleTypes.ENTITY_EFFECT)) {
            Color color = this.color.getColor(point);
            AlphaColor alphaColor = new AlphaColor(color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
            return (T)new ParticleColorData(alphaColor);
        }
        return (T)ParticleData.emptyData();
    }
}

