/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.border.animation.particle;

import com.eternalcode.combat.border.BorderPoint;
import com.eternalcode.combat.border.animation.BorderColorUtil;
import java.awt.Color;

public class ParticleColor {
    public static final ParticleColor RAINBOW = new ParticleColor("RAINBOW", point -> BorderColorUtil.xyzToRainbow(point.x(), point.y(), point.z()));
    private final String name;
    private final ColorProvider color;

    private ParticleColor(String name, ColorProvider color) {
        this.name = name;
        this.color = color;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor(BorderPoint point) {
        return this.color.provide(point);
    }

    public static ParticleColor fromName(String name) {
        if (name.equals(ParticleColor.RAINBOW.name)) {
            return RAINBOW;
        }
        Color decoded = Color.decode(name);
        return new ParticleColor(name, point -> decoded);
    }

    private static interface ColorProvider {
        public Color provide(BorderPoint var1);
    }
}

