/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.border.animation.block;

import com.eternalcode.combat.border.BorderPoint;
import com.eternalcode.combat.border.BorderService;
import com.eternalcode.combat.border.animation.block.BlockSettings;
import com.eternalcode.combat.border.animation.block.ChunkCache;
import com.eternalcode.combat.border.animation.block.ChunkLocation;
import com.eternalcode.combat.border.event.BorderHideAsyncEvent;
import com.eternalcode.combat.border.event.BorderShowAsyncEvent;
import com.eternalcode.combat.libs.com.eternalcode.commons.scheduler.Scheduler;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerMultiBlockChange;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class BorderBlockController
implements Listener {
    public static final PacketEventsAPI<?> PACKET_EVENTS = PacketEvents.getAPI();
    public static final PlayerManager PLAYER_MANAGER = PACKET_EVENTS.getPlayerManager();
    public static final ClientVersion SERVER_VERSION = PACKET_EVENTS.getServerManager().getVersion().toClientVersion();
    public static final int AIR_ID = WrappedBlockState.getDefaultState((ClientVersion)SERVER_VERSION, (StateType)StateTypes.AIR).getGlobalId();
    public static final int MINECRAFT_CHUNK_SHIFT = 4;
    private final BorderService borderService;
    private final Supplier<BlockSettings> settings;
    private final Server server;
    private final Set<UUID> playersToUpdate = ConcurrentHashMap.newKeySet();
    private final Map<UUID, Object> lockedPlayers = new ConcurrentHashMap<UUID, Object>();
    private final ChunkCache chunkCache;

    public BorderBlockController(BorderService borderService, Supplier<BlockSettings> settings, Scheduler scheduler, Server server) {
        this.borderService = borderService;
        this.settings = settings;
        this.server = server;
        this.chunkCache = new ChunkCache(settings.get());
        scheduler.timerAsync(() -> this.updatePlayers(), settings.get().updateDelay, settings.get().updateDelay);
    }

    @EventHandler
    void onBorderShowAsyncEvent(BorderShowAsyncEvent event) {
        if (!this.settings.get().enabled) {
            return;
        }
        Player player = event.getPlayer();
        Set<BorderPoint> borderPoints = this.getPointsWithoutAir(player, event.getPoints());
        event.setPoints(borderPoints);
        this.showBlocks(player, borderPoints);
        this.playersToUpdate.add(player.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    void onBorderHideAsyncEvent(BorderHideAsyncEvent event) {
        Object lock;
        if (!this.settings.get().enabled) {
            return;
        }
        Object object = lock = this.lockedPlayers.computeIfAbsent(event.getPlayer().getUniqueId(), k -> new Object());
        synchronized (object) {
            this.hideBlocks(event.getPlayer(), event.getPoints());
            Set<BorderPoint> border = this.borderService.getActiveBorder(event.getPlayer());
            if (border.isEmpty()) {
                this.playersToUpdate.remove(event.getPlayer().getUniqueId());
            }
        }
    }

    private void updatePlayers() {
        if (!this.settings.get().enabled) {
            return;
        }
        for (UUID uuid : this.playersToUpdate) {
            Player player = this.server.getPlayer(uuid);
            if (player == null) {
                this.playersToUpdate.remove(uuid);
                continue;
            }
            this.updatePlayer(uuid, player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlayer(UUID uuid, Player player) {
        Object lock;
        Object object = lock = this.lockedPlayers.computeIfAbsent(uuid, k -> new Object());
        synchronized (object) {
            Set<BorderPoint> border = this.borderService.getActiveBorder(player);
            if (border.isEmpty()) {
                this.playersToUpdate.remove(uuid);
                return;
            }
            this.showBlocks(player, border);
        }
    }

    private void showBlocks(Player player, Collection<BorderPoint> blocks) {
        this.splitByChunks(blocks).entrySet().stream().map(chunkBlocks -> this.toMultiBlockChangePacket((Map.Entry<Vector3i, Set<BorderPoint>>)chunkBlocks)).forEach(change -> PLAYER_MANAGER.sendPacket((Object)player, (PacketWrapper)change));
    }

    private WrapperPlayServerMultiBlockChange toMultiBlockChangePacket(Map.Entry<Vector3i, Set<BorderPoint>> chunkBlocks) {
        WrapperPlayServerMultiBlockChange.EncodedBlock[] encodedBlocks = (WrapperPlayServerMultiBlockChange.EncodedBlock[])chunkBlocks.getValue().stream().map(borderPoint -> this.toEncodedBlock((BorderPoint)borderPoint)).toArray(WrapperPlayServerMultiBlockChange.EncodedBlock[]::new);
        return new WrapperPlayServerMultiBlockChange(chunkBlocks.getKey(), Boolean.valueOf(true), encodedBlocks);
    }

    private void hideBlocks(Player player, Collection<BorderPoint> blocks) {
        this.splitByChunks(blocks).entrySet().stream().map(chunkBlocks -> this.toMultiAirChangePacket((Map.Entry<Vector3i, Set<BorderPoint>>)chunkBlocks)).forEach(change -> PLAYER_MANAGER.sendPacket((Object)player, (PacketWrapper)change));
    }

    private WrapperPlayServerMultiBlockChange toMultiAirChangePacket(Map.Entry<Vector3i, Set<BorderPoint>> chunkBlocks) {
        WrapperPlayServerMultiBlockChange.EncodedBlock[] encodedBlocks = (WrapperPlayServerMultiBlockChange.EncodedBlock[])chunkBlocks.getValue().stream().map(point -> new WrapperPlayServerMultiBlockChange.EncodedBlock(AIR_ID, point.x(), point.y(), point.z())).toArray(WrapperPlayServerMultiBlockChange.EncodedBlock[]::new);
        return new WrapperPlayServerMultiBlockChange(chunkBlocks.getKey(), Boolean.valueOf(true), encodedBlocks);
    }

    private Set<BorderPoint> getPointsWithoutAir(Player player, Collection<BorderPoint> blocks) {
        Map chunksToProcess = blocks.stream().map(borderPoint -> borderPoint.toInclusive()).collect(Collectors.groupingBy(inclusive -> new ChunkLocation(inclusive.x() >> 4, inclusive.z() >> 4), Collectors.toSet()));
        return chunksToProcess.entrySet().stream().flatMap(entry -> this.getPointsWithoutAirOnChunk(player, (Map.Entry<ChunkLocation, Set<BorderPoint>>)entry)).collect(Collectors.toSet());
    }

    private Stream<BorderPoint> getPointsWithoutAirOnChunk(Player player, Map.Entry<ChunkLocation, Set<BorderPoint>> entry) {
        ChunkSnapshot snapshot = this.chunkCache.loadSnapshot(player, entry.getKey());
        if (snapshot == null) {
            return Stream.empty();
        }
        return entry.getValue().stream().filter(point -> BorderBlockController.isAir((ChunkLocation)entry.getKey(), point, snapshot));
    }

    private static boolean isAir(ChunkLocation location, BorderPoint point, ChunkSnapshot chunk) {
        int xInsideChunk = point.x() - (location.x() << 4);
        int zInsideChunk = point.z() - (location.z() << 4);
        Material material = chunk.getBlockType(xInsideChunk, point.y(), zInsideChunk);
        return material.isAir();
    }

    private Map<Vector3i, Set<BorderPoint>> splitByChunks(Collection<BorderPoint> blocks) {
        return blocks.stream().collect(Collectors.groupingBy(block -> new Vector3i(block.x() >> 4, block.y() >> 4, block.z() >> 4), Collectors.toSet()));
    }

    private WrapperPlayServerMultiBlockChange.EncodedBlock toEncodedBlock(BorderPoint point) {
        StateType type = this.settings.get().type.getStateType(point);
        WrappedBlockState state = WrappedBlockState.getDefaultState((ClientVersion)SERVER_VERSION, (StateType)type);
        return new WrapperPlayServerMultiBlockChange.EncodedBlock(state.getGlobalId(), point.x(), point.y(), point.z());
    }
}

