/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.border;

import com.eternalcode.combat.border.BorderSettings;
import com.eternalcode.combat.border.BorderTrigger;
import com.eternalcode.combat.border.BorderTriggerIndexBucket;
import com.eternalcode.combat.libs.com.eternalcode.commons.bukkit.scheduler.MinecraftScheduler;
import com.eternalcode.combat.region.Region;
import com.eternalcode.combat.region.RegionProvider;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;

class BorderTriggerIndex {
    private final Server server;
    private final MinecraftScheduler scheduler;
    private final RegionProvider provider;
    private final Supplier<BorderSettings> settings;
    private final Map<String, BorderTriggerIndexBucket> borderIndexes = new HashMap<String, BorderTriggerIndexBucket>();

    private BorderTriggerIndex(Server server, MinecraftScheduler scheduler, RegionProvider provider, Supplier<BorderSettings> settings) {
        this.server = server;
        this.scheduler = scheduler;
        this.provider = provider;
        this.settings = settings;
    }

    private void updateWorlds() {
        for (World world : this.server.getWorlds()) {
            this.updateWorld(world.getName(), this.provider.getRegions(world));
        }
    }

    private void updateWorld(String world, Collection<Region> regions) {
        this.scheduler.runAsync(() -> {
            int distanceRounded = this.settings.get().distanceRounded();
            ArrayList<BorderTrigger> triggers = new ArrayList<BorderTrigger>();
            for (Region region : regions) {
                Location min = region.getMin();
                Location max = region.getMax();
                triggers.add(new BorderTrigger(min.getBlockX(), min.getBlockY(), min.getBlockZ(), max.getBlockX() + 1, max.getBlockY() + 1, max.getBlockZ() + 1, distanceRounded));
            }
            BorderTriggerIndexBucket index = BorderTriggerIndexBucket.create(triggers);
            this.borderIndexes.put(world, index);
        });
    }

    static BorderTriggerIndex started(Server server, MinecraftScheduler scheduler, RegionProvider provider, Supplier<BorderSettings> settings) {
        BorderTriggerIndex index = new BorderTriggerIndex(server, scheduler, provider, settings);
        scheduler.timerAsync(() -> index.updateWorlds(), Duration.ZERO, settings.get().indexRefreshDelay());
        return index;
    }

    public List<BorderTrigger> getTriggered(Location location) {
        BorderTriggerIndexBucket index = this.borderIndexes.get(location.getWorld().getName());
        if (index == null) {
            return List.of();
        }
        int x = (int)Math.round(location.getX());
        int y = (int)Math.round(location.getY());
        int z = (int)Math.round(location.getZ());
        return index.getTriggers(x, z).stream().filter(trigger -> trigger.isTriggered(x, y, z)).toList();
    }
}

