/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.updater;

import com.eternalcode.formatter.ChatSettings;
import com.eternalcode.formatter.libs.net.kyori.adventure.audience.Audience;
import com.eternalcode.formatter.libs.net.kyori.adventure.platform.AudienceProvider;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.Component;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import com.eternalcode.formatter.updater.UpdaterService;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class UpdaterController
implements Listener {
    private static final String NEW_VERSION_AVAILABLE = "<b><gradient:#29fbff:#38b3ff>ChatFormatter:</gradient></b> <green>New version of ChatFormatter is available, please update!";
    private final UpdaterService updaterService;
    private final ChatSettings chatSettings;
    private final AudienceProvider audienceProvider;
    private final MiniMessage miniMessage;

    public UpdaterController(UpdaterService updaterService, ChatSettings chatSettings, AudienceProvider audienceProvider, MiniMessage miniMessage) {
        this.updaterService = updaterService;
        this.chatSettings = chatSettings;
        this.audienceProvider = audienceProvider;
        this.miniMessage = miniMessage;
    }

    @EventHandler
    void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Audience audience = this.audienceProvider.player(player.getUniqueId());
        if (!player.hasPermission("chatformatter.receiveupdates") || !this.chatSettings.isReceiveUpdates()) {
            return;
        }
        CompletableFuture<Boolean> upToDate = this.updaterService.isUpToDate();
        upToDate.whenComplete((isUpToDate, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
                return;
            }
            if (!isUpToDate.booleanValue()) {
                audience.sendMessage((Component)this.miniMessage.deserialize(NEW_VERSION_AVAILABLE));
            }
        });
    }
}

