/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.placeholder;

import com.eternalcode.formatter.placeholder.RelationalReplacer;
import com.eternalcode.formatter.placeholder.Replacer;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class PlaceholderRegistry {
    private final Set<Replacer> replacers = new HashSet<Replacer>();
    private final Set<RelationalReplacer> relationalReplacers = new HashSet<RelationalReplacer>();

    public void addReplacer(Replacer stack) {
        this.replacers.add(stack);
    }

    public void addRelationalReplacer(RelationalReplacer stack) {
        this.relationalReplacers.add(stack);
    }

    public String format(String text, Player target) {
        return this.format(text, target, null);
    }

    public String format(String text, Player target, @Nullable Player viewer) {
        String beforeReplacements;
        int iterations = 0;
        do {
            beforeReplacements = text;
            if (viewer != null) {
                for (RelationalReplacer relationalReplacer : this.relationalReplacers) {
                    text = relationalReplacer.apply(text, target, viewer);
                }
            }
            for (Replacer replacer : this.replacers) {
                text = replacer.apply(text, target);
            }
        } while (!text.equals(beforeReplacements) && iterations++ < 10);
        return text;
    }
}

