/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.paper;

import com.eternalcode.formatter.ChatHandler;
import com.eternalcode.formatter.ChatMessage;
import com.eternalcode.formatter.ChatRenderedMessage;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Optional;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.jetbrains.annotations.NotNull;

class PaperChatEventExecutor
implements EventExecutor {
    private static final GsonComponentSerializer GSON = GsonComponentSerializer.gson();

    PaperChatEventExecutor() {
    }

    public void execute(@NotNull Listener listener, @NotNull Event event) throws EventException {
        if (!(listener instanceof ChatHandler)) {
            throw new EventException("Listener is not a ChatHandler");
        }
        ChatHandler handler = (ChatHandler)listener;
        if (!(event instanceof AsyncChatEvent)) {
            return;
        }
        AsyncChatEvent paperEvent = (AsyncChatEvent)event;
        paperEvent.renderer((source, sourceDisplayName, ignored, viewer) -> {
            String jsonMessage = (String)GSON.serialize(paperEvent.message());
            Optional<Player> optionalViewer = viewer.get(Identity.UUID).map(uuid -> source.getServer().getPlayer(uuid));
            ChatMessage chatMessage = new ChatMessage(source, optionalViewer, jsonMessage);
            ChatRenderedMessage result = handler.process(chatMessage);
            return GSON.deserialize((Object)result.jsonMessage());
        });
    }
}

