/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.utilities.text;

import com.eternalcode.formatter.libs.panda.std.Option;
import com.eternalcode.formatter.libs.panda.utilities.StringUtils;
import com.eternalcode.formatter.libs.panda.utilities.UnsafeUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Formatter {
    private final Map<String, Supplier<?>> placeholders;
    private final Function<String, Option<Exception>> verifier;

    public Formatter(Map<String, Supplier<?>> placeholders, Function<String, Option<Exception>> verifier) {
        this.placeholders = placeholders;
        this.verifier = verifier;
    }

    public Formatter(Function<String, Option<Exception>> verifier) {
        this(new LinkedHashMap(), verifier);
    }

    public Formatter() {
        this(new LinkedHashMap(), message -> Option.none());
    }

    public String format(String message) {
        for (Map.Entry<String, Supplier<?>> placeholderEntry : this.placeholders.entrySet()) {
            String key = placeholderEntry.getKey();
            if (!message.contains(key)) continue;
            Object value = placeholderEntry.getValue().get();
            if (value == null) {
                throw new NullPointerException("Placeholder " + key + " returns null value");
            }
            message = StringUtils.replace(message, key, Objects.toString(value));
        }
        Option<Exception> verificationResult = this.verifier.apply(message);
        if (verificationResult.isPresent()) {
            return (String)UnsafeUtils.throwException(verificationResult.get());
        }
        return message;
    }

    public Formatter register(String placeholder, Object value) {
        return this.register(placeholder, value::toString);
    }

    public Formatter register(String placeholder, Supplier<?> value) {
        this.placeholders.put(placeholder, value);
        return this;
    }

    public Formatter fork() {
        return new Formatter(new LinkedHashMap(this.placeholders), this.verifier);
    }

    public <T> T getValue(String placeholder) {
        Supplier<?> supplier = this.placeholders.get(placeholder);
        return (T)supplier.get();
    }
}

