/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.utilities.iterable;

public final class CharArrayDistributor {
    private final char[] array;
    private int index;

    public CharArrayDistributor(char[] array) {
        this.array = array;
        this.index = -1;
    }

    public CharArrayDistributor(String pattern) {
        this(pattern.toCharArray());
    }

    public char previous() {
        if (this.index - 1 < this.array.length) {
            --this.index;
            if (this.index < -1) {
                this.index = -1;
            }
            return this.current();
        }
        return this.getLast();
    }

    public char current() {
        return this.index < this.array.length && this.index > -1 ? this.array[this.index] : this.array[0];
    }

    public char next() {
        if (this.index + 1 < this.array.length) {
            return this.array[++this.index];
        }
        return this.getLast();
    }

    public char further() {
        if (this.index + 1 < this.array.length) {
            return this.array[this.index + 1];
        }
        return this.getLast();
    }

    public char future() {
        if (this.index + 2 < this.array.length) {
            return this.array[this.index + 2];
        }
        return this.getLast();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean hasNext() {
        return this.index + 1 < this.array.length;
    }

    public char getPrevious(int t) {
        return this.index - t > 0 ? this.array[this.index - t] : this.array[0];
    }

    public char getPrevious() {
        return this.index - 1 > 0 ? this.array[this.index - 1] : this.array[0];
    }

    public char getNext() {
        return this.index + 1 < this.array.length ? this.array[this.index + 1] : this.getLast();
    }

    public char getLast() {
        return this.array[this.array.length - 1];
    }

    public int getIndex() {
        return this.index;
    }
}

