/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.utilities.console;

import com.eternalcode.formatter.libs.panda.utilities.StringUtils;

public enum Effect {
    LINE_SEPARATOR("\n", "n"),
    RESET("\u001b[0m", "r"),
    BOLD("\u001b[0;1m", "b"),
    BLACK("\u001b[0;30m", "0"),
    RED("\u001b[0;31m", "1"),
    GREEN("\u001b[0;32m", "2"),
    YELLOW("\u001b[0;33m", "3"),
    BLUE("\u001b[0;34m", "4"),
    MAGENTA("\u001b[0;35m", "5"),
    CYAN("\u001b[0;36m", "6"),
    WHITE("\u001b[0;37m", "7"),
    BLACK_BOLD("\u001b[1;30m", "0b"),
    RED_BOLD("\u001b[1;31m", "1b"),
    GREEN_BOLD("\u001b[1;32m", "2b"),
    YELLOW_BOLD("\u001b[1;33m", "3b"),
    BLUE_BOLD("\u001b[1;34m", "4b"),
    MAGENTA_BOLD("\u001b[1;35m", "5b"),
    CYAN_BOLD("\u001b[1;36m", "6b"),
    WHITE_BOLD("\u001b[1;37m", "7b"),
    BLACK_UNDERLINED("\u001b[4;30m", "0u"),
    RED_UNDERLINED("\u001b[4;31m", "1u"),
    GREEN_UNDERLINED("\u001b[4;32m", "2u"),
    YELLOW_UNDERLINED("\u001b[4;33m", "3u"),
    BLUE_UNDERLINED("\u001b[4;34m", "4u"),
    MAGENTA_UNDERLINED("\u001b[4;35m", "5u"),
    CYAN_UNDERLINED("\u001b[4;36m", "6u"),
    WHITE_UNDERLINED("\u001b[4;37m", "7u");

    public static final char EFFECT_OPERATOR = '&';
    private final String code;
    private final String simpleCode;

    private Effect(String code, String simpleCode) {
        this.code = code;
        this.simpleCode = simpleCode;
    }

    public String getSimpleCode() {
        return this.simpleCode;
    }

    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.getCode();
    }

    public static String paint(String text) {
        for (Effect effect : Effect.values()) {
            text = StringUtils.replace(text, '&' + effect.simpleCode, effect.code);
        }
        return text + (Object)((Object)RESET);
    }
}

