/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.utilities.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class Node<T> {
    private final T element;
    private final Set<Node<T>> children;

    public Node(T element) {
        this.element = element;
        this.children = new HashSet<Node<T>>();
    }

    public Set<T> collectLeafs(Predicate<T> filter) {
        HashSet<T> leafs = new HashSet<T>();
        for (Node<T> child : this.children) {
            leafs.addAll(child.collectLeafs(filter));
        }
        if (leafs.isEmpty() && filter.test(this.getElement())) {
            leafs.add(this.getElement());
        }
        return leafs;
    }

    @Nullable
    public Node<T> find(T element) {
        if (Objects.equals(element, this.getElement())) {
            return this;
        }
        for (Node<T> child : this.getChildren()) {
            Node<T> result = child.find(element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public List<Node<T>> trace(T element) {
        if (Objects.equals(element, this.getElement())) {
            return Collections.singletonList(this);
        }
        ArrayList<Node<T>> trace = new ArrayList<Node<T>>();
        for (Node<T> child : this.getChildren()) {
            @Nullable List<Node<T>> result = child.trace(element);
            if (result == null) continue;
            trace.add(this);
            trace.addAll(result);
            return trace;
        }
        return null;
    }

    public Node<T> add(Node<T> node) {
        this.children.add(node);
        return node;
    }

    public void add(Collection<Node<T>> nodes) {
        this.children.addAll(nodes);
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public Set<Node<T>> getChildren() {
        return this.children;
    }

    public T getElement() {
        return this.element;
    }

    public String toString() {
        return "Node::" + this.getElement();
    }
}

