/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.utilities.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class Lists {
    private Lists() {
    }

    public static <T> T add(Collection<T> list, T element) {
        list.add(element);
        return element;
    }

    public static <T> List<T> subList(List<T> list, int startIndex) {
        return list.subList(startIndex, list.size());
    }

    public static <T> ArrayList<T> subList(List<T> list, int startIndex, int endIndex) {
        return new ArrayList<T>(list.subList(startIndex, endIndex));
    }

    @SafeVarargs
    public static <T> void sort(Comparator<T> comparator, List<? extends T> ... collections) {
        for (List<T> list : collections) {
            list.sort(comparator);
        }
    }

    public static <T> List<T> reverse(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    public static <T> List<T>[] split(List<T> list, T delimiter) {
        ArrayList<List<T>> elements = new ArrayList<List<T>>();
        int previousIndex = -1;
        for (int index = 0; index < list.size(); ++index) {
            if (!list.get(index).equals(delimiter)) continue;
            elements.add(list.subList(++previousIndex, index));
            previousIndex = index;
        }
        if (previousIndex > -1) {
            elements.add(Lists.subList(list, ++previousIndex));
        }
        if (elements.isEmpty()) {
            elements.add(list);
        }
        return elements.toArray(new List[0]);
    }

    @SafeVarargs
    public static <T> List<T> mutableOf(T ... elements) {
        return new ArrayList<T>(Arrays.asList(elements));
    }

    @Nullable
    public static <T> T get(List<T> list, int index) {
        return index > -1 && index < list.size() ? (T)list.get(index) : null;
    }
}

