/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.utilities;

import java.lang.management.ManagementFactory;
import java.util.Locale;

public final class TimeUtils {
    public static final double MILLISECOND = 1000.0;
    public static final double NANOSECOND = 1000000.0;

    private TimeUtils() {
    }

    public static String toSeconds(long ms) {
        return TimeUtils.format((double)ms / 1000.0) + "s";
    }

    public static String toMilliseconds(long nano) {
        return TimeUtils.format((double)nano / 1000000.0) + "ms";
    }

    public static String format(double time) {
        return String.format(Locale.US, "%.2f", time);
    }

    public static double getUptime(long uptime) {
        return (double)(System.currentTimeMillis() - uptime) / 1000.0;
    }

    public static long getJVMUptime() {
        return System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getStartTime();
    }
}

