/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.utilities;

import com.eternalcode.formatter.libs.panda.utilities.ArrayUtils;
import com.eternalcode.formatter.libs.panda.utilities.CharacterUtils;
import com.eternalcode.formatter.libs.panda.utilities.text.Joiner;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public final class StringUtils {
    public static final String EMPTY = "";
    public static final String[] EMPTY_ARRAY = new String[0];

    private StringUtils() {
    }

    public static String[] splitFirst(String text, String delimiter) {
        int index = text.indexOf(delimiter);
        if (index == -1) {
            return EMPTY_ARRAY;
        }
        return new String[]{text.substring(0, index), text.substring(index + 1)};
    }

    public static String[] split(String text, String delimiter) {
        int occurrences = StringUtils.countOccurrences(text, delimiter);
        if (occurrences == 0) {
            return new String[]{text};
        }
        String[] elements = new String[occurrences + 1];
        int arrayIndex = 0;
        int index = 0;
        while (index < text.length()) {
            int currentIndex = text.indexOf(delimiter, index);
            if (currentIndex == -1) {
                elements[arrayIndex++] = text.substring(index);
                break;
            }
            elements[arrayIndex++] = text.substring(index, currentIndex);
            index = currentIndex + delimiter.length();
        }
        if (text.endsWith(delimiter)) {
            elements[arrayIndex] = EMPTY;
        }
        return elements;
    }

    public static int lastIndexOfBefore(String text, String element, int occurrences) {
        int currentIndex;
        int occurrence = 0;
        int index = text.length() - 1;
        while (index > -1 && (currentIndex = StringUtils.lastIndexOf(text, element, index)) != -1) {
            if (++occurrence == occurrences) {
                return currentIndex;
            }
            index = currentIndex + text.length();
        }
        return -1;
    }

    public static int lastIndexOf(String text, String element, int toIndex) {
        if (toIndex < 1 || toIndex > text.length()) {
            return -1;
        }
        return text.substring(0, toIndex).lastIndexOf(element);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, 0, -1);
    }

    private static String replace(@Nullable String text, @Nullable String pattern, String replacement, int fromIndex, int max) {
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(pattern)) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(pattern, fromIndex);
        if (end == -1) {
            return text;
        }
        int replaceLength = pattern.length();
        int increase = replacement.length() - replaceLength;
        increase = Math.max(increase, 0);
        StringBuilder builder = new StringBuilder(text.length() + (increase *= 16));
        while (end != -1) {
            builder.append(text, start, end).append(replacement);
            start = end + replaceLength;
            if (--max == 0) break;
            end = text.indexOf(pattern, start);
        }
        builder.append(text.substring(start));
        return builder.toString();
    }

    public static String replaceFirst(String text, String pattern, String replacement) {
        return StringUtils.replaceFirst(text, pattern, replacement, 0);
    }

    public static String replaceFirst(String text, String pattern, String replacement, int start) {
        return StringUtils.replace(text, pattern, replacement, start, 1);
    }

    public static String replaceRespectively(String text, String pattern, String ... values) {
        return StringUtils.replaceRespectivelyInternal(text, pattern, false, values);
    }

    public static String replaceRespectivelyAndSoftly(String text, String pattern, String ... values) {
        return StringUtils.replaceRespectivelyInternal(text, pattern, true, values);
    }

    private static String replaceRespectivelyInternal(String text, String pattern, boolean soft, String ... values) {
        if (!soft && values.length != StringUtils.countOccurrences(text, pattern)) {
            throw new IllegalArgumentException("The amount of values does not match the amount of pattern occurrences");
        }
        if (ArrayUtils.containsNull(values)) {
            throw new IllegalArgumentException("Array of values contains null");
        }
        int[] positions = new int[values.length];
        int previousIndex = 0;
        for (int i = 0; i < positions.length; ++i) {
            int index;
            positions[i] = index = text.indexOf(pattern, previousIndex);
            previousIndex = index + pattern.length();
        }
        int diff = 0;
        for (int i = 0; i < values.length; ++i) {
            text = StringUtils.replaceFirst(text, pattern, values[i], positions[i] + diff);
            diff += -pattern.length() + values[i].length();
        }
        return text;
    }

    public static String capitalize(String text) {
        int codePoint;
        int newCodePoint;
        int strLen;
        if (text == null || (strLen = text.length()) == 0) {
            return text;
        }
        int firstCodePoint = text.codePointAt(0);
        if (firstCodePoint == (newCodePoint = Character.toTitleCase(firstCodePoint))) {
            return text;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodePoint); inOffset < strLen; inOffset += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(inOffset);
            newCodePoints[outOffset++] = codePoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static boolean startsWith(String text, Predicate<char[]> filter) {
        if (text.length() == 0) {
            return false;
        }
        return filter.test(text.toCharArray());
    }

    public static String trimStart(String text) {
        int index;
        char[] chars = text.toCharArray();
        for (index = 0; index < chars.length && chars[index] <= ' '; ++index) {
        }
        return text.substring(index, chars.length);
    }

    public static String trimEnd(String text) {
        int length;
        char[] chars = text.toCharArray();
        for (length = text.length(); length > 0 && chars[length - 1] <= ' '; --length) {
        }
        return text.substring(0, length);
    }

    public static String extractParagraph(String str) {
        int count = str.indexOf(str.trim());
        return str.substring(0, count);
    }

    public static String buildSpace(int spaces) {
        return StringUtils.repeated(spaces, " ");
    }

    public static String repeated(int repetitions, String ... elements) {
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < repetitions; ++i) {
            for (String element : elements) {
                content.append(element);
            }
        }
        return content.toString();
    }

    public static int countOccurrences(String text, String element) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = text.indexOf(element, lastIndex)) == -1) continue;
            ++count;
            lastIndex += element.length();
        }
        return count;
    }

    public static boolean containsCharacter(String text, char ... characters) {
        return StringUtils.contains(text, character -> CharacterUtils.belongsTo(character.charValue(), characters));
    }

    public static boolean containsSpecialCharacters(String text) {
        return StringUtils.contains(text, character -> !Character.isLetterOrDigit(character.charValue()));
    }

    public static boolean containsOtherCharacters(String text, char[] ... characters) {
        return StringUtils.contains(text, character -> !CharacterUtils.belongsToAny(character.charValue(), characters));
    }

    private static boolean contains(String text, Function<Character, Boolean> condition) {
        for (char c : text.toCharArray()) {
            if (!condition.apply(Character.valueOf(c)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static String join(String ... strings) {
        StringBuilder content = new StringBuilder();
        for (String string : strings) {
            content.append(string);
        }
        return content.toString();
    }

    public static String toString(@Nullable Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            return Joiner.on(", ").join((Object[])object).toString();
        }
        return object.toString();
    }

    public static boolean isNumber(String str) {
        return StringUtils.contains(str, character -> Character.isDigit(character.charValue()) || character.charValue() == 'x' || character.charValue() == '.');
    }

    public static String isEmpty(String text, String exceptionMessage) {
        if (StringUtils.isEmpty(text)) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        return text;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }
}

