/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.utilities;

import com.eternalcode.formatter.libs.panda.std.Option;
import com.eternalcode.formatter.libs.panda.std.stream.PandaStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <E extends Executable> Collection<E> getByModifier(E[] executables, int modifier) {
        return Arrays.stream(executables).filter(executable -> (executable.getModifiers() & modifier) != 0).collect(Collectors.toList());
    }

    public static Option<Method> getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return PandaStream.of(ReflectionUtils.getMethods(clazz, methodName)).filter(method -> Arrays.equals(method.getParameterTypes(), parameterTypes)).head();
    }

    public static List<Method> getMethods(Class<?> clazz, String methodName) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.getName().equals(methodName)).collect(Collectors.toList());
    }

    public static Set<Method> getMethodsAnnotatedWith(Class<?> clazz, Class<? extends Annotation> annotation) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> currentClazz = clazz; currentClazz != Object.class; currentClazz = currentClazz.getSuperclass()) {
            methods.addAll(Arrays.stream(currentClazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(annotation)).collect(Collectors.toList()));
        }
        return methods;
    }

    public static <T> Collection<T> getStaticFieldValues(Class<?> clazz, Class<T> type) {
        return ReflectionUtils.getFieldValues(clazz, type, null);
    }

    public static <R, T> Collection<R> getFieldValues(Class<T> clazz, Class<R> type, @Nullable T instance) {
        Collection fields = Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getType() == type).filter(field -> instance != null || Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
        ArrayList<Object> values = new ArrayList<Object>(fields.size());
        try {
            for (Field field2 : fields) {
                field2.setAccessible(true);
                values.add(field2.get(instance));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Cannot access field", illegalAccessException);
        }
        return values;
    }
}

