/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.utilities;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class ObjectUtils {
    private ObjectUtils() {
    }

    @Nullable
    public static <T> T cast(Class<T> clazz, @Nullable Object object) {
        if (!clazz.isInstance(object)) {
            return null;
        }
        return clazz.cast(object);
    }

    @Nullable
    public static <T> T cast(Object object) {
        return (T)object;
    }

    public static boolean isNotNull(@Nullable Object object) {
        return object != null;
    }

    public static boolean areNull(Object ... objects) {
        for (Object object : objects) {
            if (object == null) continue;
            return false;
        }
        return objects.length > 0;
    }

    public static boolean equalsOneOf(Object value, Object ... expected) {
        for (Object expectedValue : expected) {
            if (!Objects.equals(value, expectedValue)) continue;
            return true;
        }
        return false;
    }

    public static <T, C> boolean equals(T object, C value, Object to, Function<T, C> getter) {
        return ObjectUtils.equals(object, to, (a, b) -> Objects.equals(value, getter.apply(b)));
    }

    public static <T> boolean equals(T object, Object to, BiPredicate<T, T> equals) {
        if (object == to) {
            return true;
        }
        if (to == null || object.getClass() != to.getClass()) {
            return false;
        }
        return equals.test(object, to);
    }
}

