/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.utilities;

import com.eternalcode.formatter.libs.panda.utilities.StringUtils;
import com.eternalcode.formatter.libs.panda.utilities.collection.Node;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class FileUtils {
    private FileUtils() {
    }

    public static boolean contains(File[] files, String fileName) {
        return Arrays.stream(files).anyMatch(file -> file.getName().equals(fileName));
    }

    public static int getAmountOfFiles(File directory) {
        return directory.isDirectory() ? Objects.requireNonNull(directory.listFiles()).length : 0;
    }

    public static String getContentOfFile(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
    }

    public static String[] getContentAsLines(File file) throws IOException {
        List<String> list = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
        return list.toArray(StringUtils.EMPTY_ARRAY);
    }

    public static Collection<File> findFilesByExtension(String directory, String extension) {
        return FileUtils.findFilesByExtension(new File(directory), extension);
    }

    public static Collection<File> findFilesByExtension(File directory, String extension) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtils.findFilesByExtension(directory, extension, files);
        return files;
    }

    private static void findFilesByExtension(File directory, String extension, Collection<File> files) {
        if (!directory.isDirectory()) {
            return;
        }
        for (File file : Objects.requireNonNull(directory.listFiles())) {
            if (file.isDirectory()) {
                FileUtils.findFilesByExtension(file, extension, files);
                continue;
            }
            if (!file.getName().endsWith(extension)) continue;
            files.add(file);
        }
    }

    public static Node<File> collectFiles(File directory) {
        Node<File> tree = new Node<File>(directory);
        if (!directory.isDirectory()) {
            return tree;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return tree;
        }
        for (File file : files) {
            tree.add(file.isDirectory() ? FileUtils.collectFiles(file) : new Node<File>(file));
        }
        return tree;
    }

    public static void overrideFile(File file, String content) throws IOException {
        Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static boolean delete(File file) {
        File[] files;
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File c : files) {
                FileUtils.delete(c);
            }
        }
        return file.delete();
    }

    public static File[] toFiles(String ... paths) {
        return (File[])Arrays.stream(paths).map(File::new).toArray(File[]::new);
    }

    public static String getName(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(".");
        return pos == -1 ? name : name.substring(0, pos);
    }

    public static String getName(URL url) {
        String path = url.toString();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static String getName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }
}

