/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.utilities;

import com.eternalcode.formatter.libs.panda.std.Option;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class ClassUtils {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_EQUIVALENT = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Void.TYPE, Void.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Character.TYPE, Character.class);
        }
    };

    private ClassUtils() {
    }

    public static Class<?> getNonPrimitiveClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        return PRIMITIVE_EQUIVALENT.get(clazz);
    }

    public static Option<Class<?>> selectMostRelated(Collection<? extends Class<?>> classes, Class<?> to) {
        Class<?> selected = null;
        for (Class<?> clazz : classes) {
            if (!clazz.isAssignableFrom(to) || selected != null && clazz.isAssignableFrom(selected)) continue;
            selected = clazz;
        }
        return Option.of(selected);
    }

    public static boolean isAssignableFrom(Class<?> toClass, @Nullable Object fromObject) {
        return fromObject != null && ClassUtils.isAssignableFrom(toClass, fromObject.getClass());
    }

    public static boolean isAssignableFrom(@Nullable Class<?> toClass, @Nullable Class<?> fromClass) {
        if (toClass == null || fromClass == null) {
            return false;
        }
        if (toClass.isPrimitive()) {
            toClass = PRIMITIVE_EQUIVALENT.get(toClass);
        }
        if (fromClass.isPrimitive()) {
            fromClass = PRIMITIVE_EQUIVALENT.get(fromClass);
        }
        return toClass.isAssignableFrom(fromClass);
    }

    public static Class<?>[] getClasses(Object ... values) {
        return (Class[])Arrays.stream(values).map(object -> object != null ? object.getClass() : null).toArray(Class[]::new);
    }

    public static boolean exists(String name) {
        return ClassUtils.forName(name).isPresent();
    }

    public static <T> Option<Class<? extends T>> forName(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            return Option.of(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Option.none();
        }
    }
}

