/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.std.function;

import java.util.function.Function;

@FunctionalInterface
public interface ThrowingFunction<T, R, E extends Throwable> {
    public R apply(T var1) throws E;

    public static <T, S extends Exception> ThrowingFunction<T, T, S> identity() {
        return t -> t;
    }

    public static <T, R, E extends Throwable> Function<T, R> asFunction(ThrowingFunction<T, R, E> function, Function<E, R> exceptionHandler) {
        return value -> {
            try {
                return function.apply(value);
            }
            catch (Throwable exception) {
                return exceptionHandler.apply(exception);
            }
        };
    }
}

