/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.std.collection;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ReversedIterable<T>
implements Iterable<T> {
    private final List<T> list;

    public ReversedIterable(List<T> list) {
        this.list = list;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new ReversedIterator();
    }

    final class ReversedIterator
    implements Iterator<T> {
        private int index;

        ReversedIterator() {
            this.index = ReversedIterable.this.list.size();
        }

        @Override
        public boolean hasNext() {
            return this.index > 0;
        }

        @Override
        public T next() {
            return ReversedIterable.this.list.get(--this.index);
        }
    }
}

