/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.std;

import com.eternalcode.formatter.libs.panda.std.Quad;
import java.util.Objects;

public class Triple<A, B, C> {
    private final A first;
    private final B second;
    private final C third;

    public Triple(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <A, C, B> Triple<A, B, C> of(A first, B second, C third) {
        return new Triple<A, B, C>(first, second, third);
    }

    public <D> Quad<A, B, C, D> add(D fourth) {
        return Quad.of(this.first, this.second, this.third, fourth);
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public C getThird() {
        return this.third;
    }

    public boolean equals(Object to) {
        if (this == to) {
            return true;
        }
        if (to == null || this.getClass() != to.getClass()) {
            return false;
        }
        Triple triple = (Triple)to;
        return Objects.equals(this.first, triple.first) && Objects.equals(this.second, triple.second) && Objects.equals(this.third, triple.third);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third);
    }

    public String toString() {
        return "['" + this.first + "', '" + this.second + "', '" + this.third + "']";
    }
}

