/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.panda.std;

import com.eternalcode.formatter.libs.panda.std.AttemptFailedException;
import com.eternalcode.formatter.libs.panda.std.Blank;
import com.eternalcode.formatter.libs.panda.std.Option;
import com.eternalcode.formatter.libs.panda.std.function.ThrowingFunction;
import com.eternalcode.formatter.libs.panda.std.function.ThrowingRunnable;
import com.eternalcode.formatter.libs.panda.std.function.ThrowingSupplier;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Result<VALUE, ERROR> {
    private final State state;
    private final VALUE value;
    private final ERROR error;

    private Result(State state, @Nullable VALUE value, @Nullable ERROR error) {
        if (value != null && error != null) {
            throw new IllegalStateException("Value and error are not null - Cannot determine state of Result");
        }
        this.state = state;
        this.value = value;
        this.error = error;
    }

    @NotNull
    public static <VALUE, ERROR> Result<VALUE, ERROR> ok(VALUE value) {
        return new Result<VALUE, Object>(State.OK, value, null);
    }

    @NotNull
    public static <ERROR> Result<Blank, ERROR> ok() {
        return new Result<Blank, Object>(State.OK, Blank.BLANK, null);
    }

    @NotNull
    public static <VALUE, ERROR> Result<VALUE, ERROR> error(ERROR err) {
        return new Result<Object, ERROR>(State.ERROR, null, err);
    }

    @NotNull
    public static <VALUE> Result<VALUE, Blank> error() {
        return new Result<Object, Blank>(State.ERROR, null, Blank.BLANK);
    }

    @NotNull
    public static <VALUE, ERROR> Result<VALUE, ERROR> when(boolean condition, @NotNull Supplier<VALUE> value, @NotNull Supplier<ERROR> err) {
        return condition ? Result.ok(value.get()) : Result.error(err.get());
    }

    @NotNull
    public static <VALUE, ERROR> Result<VALUE, ERROR> when(boolean condition, VALUE value, ERROR err) {
        return condition ? Result.ok(value) : Result.error(err);
    }

    @NotNull
    public static <ERROR extends Exception> @NotNull Result<Void, @NotNull Exception> runThrowing(@NotNull @NotNull ThrowingRunnable<@NotNull Exception> runnable) throws AttemptFailedException {
        return Result.runThrowing(Exception.class, runnable);
    }

    @NotNull
    public static <ERROR extends Throwable> Result<Void, ERROR> runThrowing(@NotNull Class<? extends ERROR> exceptionType, @NotNull @NotNull ThrowingRunnable<@NotNull ERROR> runnable) throws AttemptFailedException {
        return Result.supplyThrowing(exceptionType, () -> {
            runnable.run();
            return Blank.voidness();
        });
    }

    @Deprecated
    @NotNull
    public static <VALUE> Result<VALUE, Exception> attempt(@NotNull @NotNull ThrowingSupplier<VALUE, @NotNull Exception> supplier) {
        return Result.supplyThrowing(Exception.class, supplier);
    }

    @Deprecated
    @NotNull
    public static <VALUE, ERROR extends Throwable> Result<VALUE, ERROR> attempt(@NotNull Class<? extends ERROR> exceptionType, @NotNull @NotNull ThrowingSupplier<VALUE, @NotNull ERROR> supplier) throws AttemptFailedException {
        return Result.supplyThrowing(exceptionType, supplier);
    }

    @NotNull
    public static <VALUE> Result<VALUE, Exception> supplyThrowing(@NotNull @NotNull ThrowingSupplier<VALUE, @NotNull Exception> supplier) {
        return Result.supplyThrowing(Exception.class, supplier);
    }

    @NotNull
    public static <VALUE, ERROR extends Throwable> Result<VALUE, ERROR> supplyThrowing(@NotNull Class<? extends ERROR> exceptionType, @NotNull @NotNull ThrowingSupplier<VALUE, @NotNull ERROR> supplier) throws AttemptFailedException {
        try {
            return Result.ok(supplier.get());
        }
        catch (Throwable throwable) {
            if (exceptionType.isAssignableFrom(throwable.getClass())) {
                return Result.error(throwable);
            }
            throw new AttemptFailedException(throwable);
        }
    }

    @NotNull
    public <SECOND_VALUE, R> Result<R, ERROR> merge(@NotNull Result<SECOND_VALUE, ? extends ERROR> second, @NotNull BiFunction<VALUE, SECOND_VALUE, R> mergeFunction) {
        return this.flatMap(firstValue -> second.map(secondValue -> mergeFunction.apply(firstValue, secondValue)));
    }

    @NotNull
    public <MAPPED_VALUE> Result<MAPPED_VALUE, ERROR> map(@NotNull Function<VALUE, MAPPED_VALUE> function) {
        return this.isOk() ? Result.ok(function.apply(this.get())) : this.projectToError();
    }

    @NotNull
    public Result<Blank, ERROR> mapToBlank() {
        return this.isOk() ? Result.ok() : this.projectToError();
    }

    @NotNull
    public Result<VALUE, Blank> mapErrToBlank() {
        return this.isErr() ? Result.error() : this.projectToValue();
    }

    @NotNull
    public <MAPPED_ERROR> Result<VALUE, MAPPED_ERROR> mapErr(@NotNull Function<ERROR, MAPPED_ERROR> function) {
        return this.isOk() ? this.projectToValue() : Result.error(function.apply(this.getError()));
    }

    @NotNull
    public <MAPPED_VALUE> Result<MAPPED_VALUE, ERROR> flatMap(@NotNull @NotNull Function<VALUE, @NotNull Result<MAPPED_VALUE, ? extends ERROR>> function) {
        return this.isOk() ? function.apply(this.get()) : this.projectToError();
    }

    @NotNull
    public <MAPPED_ERROR> Result<VALUE, MAPPED_ERROR> flatMapErr(@NotNull @NotNull Function<@NotNull ERROR, @NotNull Result<? extends VALUE, MAPPED_ERROR>> function) {
        return this.isErr() ? function.apply(this.getError()) : this.projectToValue();
    }

    @NotNull
    public Result<VALUE, ERROR> filter(@NotNull Predicate<VALUE> predicate, @NotNull Function<VALUE, ERROR> errorSupplier) {
        return this.isOk() && !predicate.test(this.get()) ? Result.error(errorSupplier.apply(this.get())) : this;
    }

    @NotNull
    public Result<VALUE, ERROR> filterNot(@NotNull Predicate<VALUE> predicate, @NotNull Function<VALUE, ERROR> errorSupplier) {
        return this.filter(value -> !predicate.test(value), errorSupplier);
    }

    public <COMMON> COMMON fold(@NotNull Function<VALUE, COMMON> valueMerge, @NotNull Function<ERROR, COMMON> errorMerge) {
        return this.isOk() ? valueMerge.apply(this.get()) : errorMerge.apply(this.getError());
    }

    public boolean matches(Predicate<VALUE> condition) {
        return this.isOk() && condition.test(this.value);
    }

    @NotNull
    public <MAPPED_VALUE> Result<MAPPED_VALUE, ERROR> is(@NotNull Class<MAPPED_VALUE> type, @NotNull Function<VALUE, ERROR> errorSupplier) {
        return this.filter(type::isInstance, errorSupplier).map(type::cast);
    }

    @NotNull
    public Result<ERROR, VALUE> swap() {
        return this.isOk() ? Result.error(this.get()) : Result.ok(this.getError());
    }

    public Result<VALUE, ERROR> consume(@NotNull Consumer<VALUE> valueConsumer, @NotNull Consumer<ERROR> errorConsumer) {
        return this.peek(valueConsumer).onError(errorConsumer);
    }

    @NotNull
    public <REQUIRED_VALUE, REQUIRED_ERROR> Result<REQUIRED_VALUE, REQUIRED_ERROR> project() {
        return this;
    }

    @NotNull
    public <REQUIRED_ERROR> Result<VALUE, REQUIRED_ERROR> projectToValue() {
        return this;
    }

    @NotNull
    public <REQUIRED_VALUE> Result<REQUIRED_VALUE, ERROR> projectToError() {
        return this;
    }

    @NotNull
    public Result<VALUE, ERROR> orElse(@NotNull @NotNull Function<ERROR, @NotNull Result<VALUE, ERROR>> orElse) {
        return this.isOk() ? this : orElse.apply(this.getError());
    }

    @NotNull
    public VALUE orElseGet(@NotNull Function<ERROR, VALUE> orElse) {
        return this.isOk() ? this.get() : orElse.apply(this.getError());
    }

    @NotNull
    public <E extends Exception> VALUE orThrow(@NotNull ThrowingFunction<ERROR, E, E> consumer) throws E {
        if (this.isOk()) {
            return this.get();
        }
        throw (Exception)consumer.apply(this.getError());
    }

    @Deprecated
    @NotNull
    public <E extends Exception> VALUE orElseThrow(@NotNull ThrowingFunction<ERROR, E, E> consumer) throws E {
        return this.orThrow(consumer);
    }

    @NotNull
    public Result<VALUE, ERROR> peek(@NotNull Consumer<VALUE> consumer) {
        if (this.isOk()) {
            consumer.accept(this.get());
        }
        return this;
    }

    @NotNull
    public Result<VALUE, ERROR> onError(@NotNull Consumer<ERROR> consumer) {
        if (this.isErr()) {
            consumer.accept(this.getError());
        }
        return this;
    }

    public boolean isOk() {
        return this.state == State.OK;
    }

    public boolean isErr() {
        return this.state == State.ERROR;
    }

    public VALUE get() {
        if (this.isErr()) {
            throw new IllegalStateException("Result contains error - Cannot get the success value");
        }
        return this.value;
    }

    public ERROR getError() {
        if (this.isOk()) {
            throw new IllegalStateException("Result completed successfully - Cannot get the error value");
        }
        return this.error;
    }

    public Object getAny() {
        return this.isOk() ? this.value : this.error;
    }

    public <AS> AS getAnyAs() {
        return (AS)this.getAny();
    }

    @NotNull
    public @NotNull Option<@NotNull VALUE> toOption() {
        return Option.of(this.value);
    }

    @NotNull
    public @NotNull Option<@NotNull ERROR> errorToOption() {
        return Option.of(this.error);
    }

    @Nullable
    public VALUE orNull() {
        return this.value;
    }

    public State getState() {
        return this.state;
    }

    public boolean equals(Object to) {
        if (this == to) {
            return true;
        }
        if (to == null || this.getClass() != to.getClass()) {
            return false;
        }
        Result other = (Result)to;
        return Objects.equals(this.value, other.value) && Objects.equals(this.error, other.error);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.error);
    }

    public String toString() {
        return "Result{" + (this.isOk() ? "VALUE=" + this.value : "ERR=" + this.error) + "}";
    }

    public static enum State {
        OK,
        ERROR;

    }
}

