/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.source;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.source.InputStreamSource;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.source.PathSource;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.source.Resource;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.source.StringSource;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Source {
    public String getSource();

    public static Source empty() {
        return Source.of("");
    }

    public static Source of(@NotNull String source) {
        return new StringSource(source);
    }

    public static Source ofNullable(@Nullable String source) {
        return new StringSource(source != null ? source : "");
    }

    public static Resource of(@NotNull File file) {
        return Source.of(file, StandardCharsets.UTF_8);
    }

    public static Resource of(@NotNull File parent, @NotNull String child) {
        return Source.of(new File(parent, child));
    }

    public static Resource of(@NotNull File file, @NotNull Charset encoding) {
        return new PathSource(file.getAbsoluteFile().toPath(), encoding);
    }

    public static Resource of(@NotNull File parent, @NotNull String child, @NotNull Charset encoding) {
        return Source.of(new File(parent, child), encoding);
    }

    public static Resource of(@NotNull Path path) {
        return new PathSource(path);
    }

    public static Resource of(@NotNull Path path, @NotNull Charset encoding) {
        return new PathSource(path, encoding);
    }

    public static Source of(@NotNull InputStream inputStream) {
        return Source.of(inputStream, StandardCharsets.UTF_8);
    }

    public static Source of(@NotNull InputStream inputStream, @NotNull Charset encoding) {
        return new InputStreamSource(inputStream, encoding);
    }
}

