/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.source;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.source.Resource;
import com.eternalcode.formatter.libs.panda.std.Result;
import com.eternalcode.formatter.libs.panda.utilities.FileUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

final class PathSource
implements Resource {
    private final Path path;
    private final Charset encoding;

    PathSource(Path path, Charset encoding) {
        if (path == null) {
            throw new IllegalStateException("Path cannot be null");
        }
        if (encoding == null) {
            throw new IllegalStateException("Encoding cannot be null");
        }
        this.path = path;
        this.encoding = encoding;
    }

    PathSource(Path path) {
        this(path, StandardCharsets.UTF_8);
    }

    @Override
    public Result<String, IOException> save(String content) {
        return Result.attempt(IOException.class, () -> {
            Path parent = this.path.toAbsolutePath().getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            FileUtils.overrideFile(this.path.toFile(), content);
            return content;
        });
    }

    @Override
    public String getSource() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            return "";
        }
        try {
            return new String(Files.readAllBytes(this.path), this.encoding);
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Cannot read file", ioException);
        }
    }
}

