/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.source;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.source.Source;
import com.eternalcode.formatter.libs.panda.utilities.IOUtils;
import java.io.InputStream;
import java.nio.charset.Charset;

final class InputStreamSource
implements Source {
    private final InputStream inputStream;
    private final Charset encoding;

    InputStreamSource(InputStream inputStream, Charset encoding) {
        if (inputStream == null) {
            throw new IllegalStateException("InputStream cannot be null");
        }
        if (encoding == null) {
            throw new IllegalStateException("Encoding cannot be null");
        }
        this.inputStream = inputStream;
        this.encoding = encoding;
    }

    @Override
    public String getSource() {
        try {
            String string = IOUtils.convertStreamToString(this.inputStream, this.encoding).orElseThrow(failure -> {
                throw new IllegalStateException("Cannot read input stream", (Throwable)failure);
            });
            return string;
        }
        finally {
            IOUtils.close(this.inputStream);
        }
    }
}

