/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.composers;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnException;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnSettings;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnUtils;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Element;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.TargetType;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.Composer;
import com.eternalcode.formatter.libs.panda.std.Result;
import com.eternalcode.formatter.libs.panda.std.reactive.Reference;
import com.eternalcode.formatter.libs.panda.std.reactive.ReferenceUtils;
import java.util.List;

public final class ReferenceComposer<T>
implements Composer<T> {
    @Override
    public Result<T, Exception> deserialize(CdnSettings settings, Element<?> source, TargetType type, T defaultValue, boolean entryAsRecord) {
        if (defaultValue == null) {
            return Result.error(new CdnException("Default value of reference cannot be null!"));
        }
        Reference defaultReference = (Reference)defaultValue;
        TargetType referenceType = type.getAnnotatedActualTypeArguments()[0];
        return CdnUtils.findComposer(settings, referenceType, null).flatMap(deserializer -> deserializer.deserialize(settings, source, referenceType, defaultReference.get(), entryAsRecord)).map(value -> {
            Reference reference = (Reference)defaultValue;
            ReferenceUtils.setValue(reference, value);
            return MEMBER_ALREADY_PROCESSED;
        });
    }

    @Override
    public Result<? extends Element<?>, Exception> serialize(CdnSettings settings, List<String> description, String key, TargetType type, T entity) {
        Reference reference = (Reference)entity;
        TargetType[] referenceTypes = type.getAnnotatedActualTypeArguments();
        TargetType referenceType = referenceTypes[0];
        return CdnUtils.findComposer(settings, referenceType, null).flatMap(serializer -> serializer.serialize(settings, description, key, referenceType, reference.get()));
    }
}

