/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.composers;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnException;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnSettings;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnUtils;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Element;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Entry;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Piece;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Section;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.standard.StandardOperators;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.TargetType;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.Composer;
import com.eternalcode.formatter.libs.panda.std.Option;
import com.eternalcode.formatter.libs.panda.std.Pair;
import com.eternalcode.formatter.libs.panda.std.Result;
import com.eternalcode.formatter.libs.panda.std.stream.PandaStream;
import com.eternalcode.formatter.libs.panda.utilities.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class MapComposer
implements Composer<Map<Object, Object>> {
    private static final Function<Element<?>, Option<CdnException>> isSupportedMapElement = element -> Option.when(!(element instanceof Entry) && !(element instanceof Section), new CdnException("Unsupported element in map: " + element));

    @Override
    public Result<? extends Element<?>, ? extends Exception> serialize(CdnSettings settings, List<String> description, String key, TargetType type, Map<Object, Object> entity) {
        if (entity.isEmpty()) {
            return Result.ok(new Entry(description, key, "[]"));
        }
        TargetType[] collectionTypes = type.getAnnotatedActualTypeArguments();
        TargetType keyType = collectionTypes[0];
        TargetType valueType = collectionTypes[1];
        return CdnUtils.findPairOfComposers(settings, keyType, null, valueType, null).map(serializers -> new MapComposerContext(settings, (Composer)serializers.getFirst(), keyType, (Composer)serializers.getSecond(), valueType, false)).flatMap(ctx -> this.serializeMap((MapComposerContext)ctx, description, key, entity.entrySet()));
    }

    private Result<? extends Section, ? extends Exception> serializeMap(MapComposerContext context, List<String> description, String key, Collection<? extends Map.Entry<Object, Object>> entries) {
        return PandaStream.of(entries).map(entry -> this.serializeEntry(context, (Map.Entry<Object, Object>)entry)).filterToResult(Result::errorToOption).map(serializedElementsStream -> serializedElementsStream.map(Result::get)).flatMap(serializedElementsStream -> serializedElementsStream.filterToResult(isSupportedMapElement)).map(filteredStream -> filteredStream.collect(Section.collector(() -> new Section((List<? extends String>)description, StandardOperators.OBJECT_SEPARATOR, key))));
    }

    private Result<? extends Element<?>, CdnException> serializeEntry(MapComposerContext context, Map.Entry<Object, Object> entry) {
        Result<Element<?>, CdnException> serializedKey = context.keyComposer.serialize(context.settings, Collections.emptyList(), "", context.keyType, ObjectUtils.cast(entry.getKey())).mapErr(exception -> new CdnException("Cannot serialize key of map", (Throwable)exception));
        return serializedKey.flatMap(keyElement -> context.valueComposer.serialize(context.settings, Collections.emptyList(), keyElement.getValue().toString(), context.valueType, ObjectUtils.cast(entry.getValue())).mapErr(exception -> new CdnException("Cannot serialize value of map", (Throwable)exception)));
    }

    @Override
    public Result<Map<Object, Object>, Exception> deserialize(CdnSettings settings, Element<?> source, TargetType type, Map<Object, Object> defaultValue, boolean entryAsRecord) {
        if (source instanceof Entry) {
            Entry entry = (Entry)source;
            String value = CdnUtils.destringify(entry.getPieceValue());
            return value.equals("[]") ? Result.ok(new HashMap()) : Result.error(new CdnException("Cannot deserialize map of " + value));
        }
        Section section = (Section)source;
        TargetType[] collectionTypes = type.getAnnotatedActualTypeArguments();
        TargetType keyType = collectionTypes[0];
        TargetType valueType = collectionTypes[1];
        return CdnUtils.findPairOfComposers(settings, keyType, null, valueType, null).map(serializers -> new MapComposerContext(settings, (Composer)serializers.getFirst(), keyType, (Composer)serializers.getSecond(), valueType, entryAsRecord)).flatMap(ctx -> this.deserializeElements((MapComposerContext)ctx, (Collection)section.getValue()));
    }

    private Result<Map<Object, Object>, CdnException> deserializeElements(MapComposerContext context, Collection<? extends Element<?>> elements) {
        return PandaStream.of(elements).map(element -> this.deserializeElement(context, (Element<?>)element)).filterToResult(Result::errorToOption).map(CdnUtils::streamOfResultPairToMap);
    }

    private Result<Pair<Object, Object>, CdnException> deserializeElement(MapComposerContext context, Element<?> element) {
        if (element instanceof Entry) {
            return this.deserialize(context, ((Entry)element).getName(), element);
        }
        if (element instanceof Section) {
            return this.deserialize(context, ((Section)element).getName(), element);
        }
        return Result.error(new CdnException("Unsupported element in map: " + element));
    }

    private Result<Pair<Object, Object>, CdnException> deserialize(MapComposerContext context, String name, Element<?> element) {
        Result<Object, CdnException> serializedKey = context.keyComposer.deserialize(context.settings, new Piece(name), context.keyType, null, context.entryAsRecord).mapErr(exception -> new CdnException("Cannot serialize key of map: " + name, (Throwable)exception));
        Result<Object, CdnException> serializedValue = context.valueComposer.deserialize(context.settings, element, context.valueType, null, context.entryAsRecord).mapErr(exception -> new CdnException("Cannot serialize value of map: " + element.getValue(), (Throwable)exception));
        return serializedKey.merge(serializedValue, Pair::of);
    }

    private static final class MapComposerContext {
        CdnSettings settings;
        Composer<?> keyComposer;
        TargetType keyType;
        Composer<?> valueComposer;
        TargetType valueType;
        boolean entryAsRecord;

        private MapComposerContext(CdnSettings settings, Composer<?> keyComposer, TargetType keyType, Composer<?> valueComposer, TargetType valueType, boolean entryAsRecord) {
            this.settings = settings;
            this.keyComposer = keyComposer;
            this.keyType = keyType;
            this.valueComposer = valueComposer;
            this.valueType = valueType;
            this.entryAsRecord = entryAsRecord;
        }
    }
}

