/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.composers;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnSettings;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnUtils;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Element;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Entry;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.NamedElement;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Section;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.standard.StandardOperators;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.TargetType;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.Composer;
import com.eternalcode.formatter.libs.panda.std.Result;
import com.eternalcode.formatter.libs.panda.std.stream.PandaStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ListComposer
implements Composer<List<Object>> {
    @Override
    public Result<List<Object>, Exception> deserialize(CdnSettings settings, Element<?> source, TargetType type, List<Object> defaultValue, boolean entryAsRecord) {
        if (source instanceof Entry) {
            Entry entry = (Entry)source;
            return CdnUtils.destringify(entry.getPieceValue()).trim().endsWith("[]") ? Result.ok(new ArrayList()) : Result.error(new UnsupportedOperationException("Cannot deserialize list of " + entry));
        }
        Section section = (Section)source;
        TargetType collectionType = type.getAnnotatedActualTypeArguments()[0];
        return CdnUtils.findComposer(settings, collectionType, null).flatMap(composer -> PandaStream.of((Collection)section.getValue()).map(element -> settings.getModule().resolveArrayValue((Element<?>)element)).map(element -> composer.deserialize(settings, (Element<?>)element, collectionType, null, true)).filterToResult(Result::errorToOption).map(stream -> stream.map(Result::get).toList()));
    }

    @Override
    public Result<NamedElement<?>, Exception> serialize(CdnSettings settings, List<String> description, String key, TargetType type, List<Object> entity) {
        if (entity.isEmpty()) {
            return Result.ok(new Entry(description, key, "[]"));
        }
        TargetType collectionType = type.getAnnotatedActualTypeArguments()[0];
        return CdnUtils.findComposer(settings, collectionType, null).flatMap(serializer -> PandaStream.of(entity).map(element -> serializer.serialize(settings, Collections.emptyList(), "", collectionType, element)).filterToResult(Result::errorToOption).map(stream -> stream.map(Result::get).map(serializedElement -> settings.getModule().visitArrayValue((Element<?>)serializedElement)).collect(Section.collector(() -> new Section((List<? extends String>)description, StandardOperators.ARRAY_SEPARATOR, key)))));
    }
}

