/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.composers;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnSettings;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Element;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Entry;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Piece;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.TargetType;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.Composer;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.SimpleDeserializer;
import com.eternalcode.formatter.libs.panda.std.Result;
import java.util.List;

public final class EnumComposer
implements Composer<Enum<?>>,
SimpleDeserializer<Enum<?>> {
    @Override
    public Result<Enum<?>, Exception> deserialize(TargetType type, String source) {
        return EnumComposer.searchEnum(type.getType(), source);
    }

    public static <T extends Enum<?>> Result<T, Exception> searchEnum(Class<T> enumeration, String search) {
        for (Enum each : (Enum[])enumeration.getEnumConstants()) {
            if (!each.name().equalsIgnoreCase(search)) continue;
            return Result.ok(each);
        }
        return Result.error(new IllegalArgumentException(String.format("No '%s' enum constant in %s", search, enumeration)));
    }

    @Override
    public Result<Enum<?>, Exception> deserialize(String source) {
        throw new UnsupportedOperationException("Enum deserializer requires enum class");
    }

    @Override
    public Result<? extends Element<?>, Exception> serialize(CdnSettings settings, List<String> description, String key, TargetType type, Enum<?> entity) {
        return Result.ok(key.isEmpty() ? new Piece(entity.name()) : new Entry(description, key, entity.name()));
    }
}

