/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnSettings;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnUtils;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Element;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Entry;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Piece;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.TargetType;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.Deserializer;
import com.eternalcode.formatter.libs.panda.std.Result;

@FunctionalInterface
public interface SimpleDeserializer<T>
extends Deserializer<T> {
    @Override
    default public Result<T, Exception> deserialize(CdnSettings settings, Element<?> source, TargetType type, T defaultValue, boolean entryAsRecord) {
        if (source instanceof Piece) {
            return this.deserialize(type, CdnUtils.destringify(((Piece)source).getValue()));
        }
        if (source instanceof Entry) {
            Entry entry = (Entry)source;
            return this.deserialize(type, CdnUtils.destringify(entryAsRecord ? entry.getRaw() : entry.getPieceValue()));
        }
        return Result.error(new UnsupportedOperationException(String.format("Simple deserializer can deserialize only units (%s from %s)", type, source.getClass())));
    }

    default public Result<T, Exception> deserialize(TargetType type, String source) {
        return this.deserialize(source);
    }

    public Result<T, Exception> deserialize(String var1);
}

