/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnException;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnSettings;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnUtils;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.entity.Contextual;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Configuration;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Section;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.standard.StandardOperators;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.AnnotatedMember;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.TargetType;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.DescriptionResolver;
import com.eternalcode.formatter.libs.panda.std.Blank;
import com.eternalcode.formatter.libs.panda.std.Option;
import com.eternalcode.formatter.libs.panda.std.Result;
import com.eternalcode.formatter.libs.panda.std.stream.PandaStream;
import java.util.ArrayList;
import java.util.List;

public final class CdnSerializer {
    private final CdnSettings settings;

    public CdnSerializer(CdnSettings settings) {
        this.settings = settings;
    }

    public Result<Configuration, CdnException> serialize(Object entity) {
        return this.serialize(entity, new Configuration());
    }

    public <S extends Section> Result<S, CdnException> serialize(Object entity, S output) {
        Class<?> type = entity.getClass();
        ArrayList<AnnotatedMember> members = new ArrayList<AnnotatedMember>();
        members.addAll(this.settings.getAnnotationResolver().getFields(type));
        members.addAll(this.settings.getAnnotationResolver().getProperties(type));
        for (AnnotatedMember annotatedMember : members) {
            Result<Blank, ? extends Exception> serializeResult = this.serializeMember(output, annotatedMember, entity);
            if (!serializeResult.isErr()) continue;
            return serializeResult.mapErr(CdnException::new).projectToError();
        }
        return Result.ok(output);
    }

    private Result<Blank, ? extends Exception> serializeMember(Section output, AnnotatedMember member, Object instance) {
        if (member.isIgnored()) {
            return Result.ok();
        }
        Result<Option<Object>, ReflectiveOperationException> propertyValueResult = member.getValue(instance);
        if (propertyValueResult.isErr()) {
            return Result.error(propertyValueResult.getError());
        }
        ArrayList allDescriptions = new ArrayList();
        for (DescriptionResolver<?> descriptionResolver : this.settings.getDescriptionResolvers()) {
            Class<?> type = descriptionResolver.getAnnotationType();
            List description = PandaStream.of(member.getAnnotationsByType(type)).flatMap(descriptionResolver::getDescription).toList();
            allDescriptions.addAll(description);
        }
        Option<Object> propertyValue = propertyValueResult.get();
        if (member.isAnnotationPresent(Contextual.class)) {
            Section section = new Section(allDescriptions, StandardOperators.OBJECT_SEPARATOR, member.getName());
            output.append(section);
            return this.serialize(propertyValue.get(), section).mapToBlank();
        }
        TargetType targetType = member.getTargetType();
        return propertyValue.map(value -> CdnUtils.findComposer(this.settings, targetType, member).flatMap(serializer -> serializer.serialize(this.settings, allDescriptions, member.getName(), targetType, value)).peek(output::append).mapToBlank()).orElseGet(Result.ok());
    }
}

