/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnUtils;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.AnnotatedMember;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.AnnotatedTargetType;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.MemberResolver;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.TargetType;
import com.eternalcode.formatter.libs.panda.std.Blank;
import com.eternalcode.formatter.libs.panda.std.Option;
import com.eternalcode.formatter.libs.panda.std.Result;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FieldMember
implements AnnotatedMember {
    private final Field field;
    private final MemberResolver resolver;

    public FieldMember(Field field, MemberResolver resolver) {
        this.field = field;
        this.resolver = resolver;
        this.field.setAccessible(true);
    }

    @Override
    public boolean isIgnored() {
        return CdnUtils.isIgnored(this.field, this.resolver.getVisibility());
    }

    @Override
    public Result<Blank, ReflectiveOperationException> setValue(@NotNull Object instance, @NotNull Object value) {
        return Result.attempt(ReflectiveOperationException.class, () -> {
            this.field.set(instance, value);
            return Blank.BLANK;
        });
    }

    @Override
    public Result<Option<Object>, ReflectiveOperationException> getValue(@NotNull Object instance) {
        return Result.attempt(ReflectiveOperationException.class, () -> Option.of(this.field.get(instance)));
    }

    @Override
    public boolean isAnnotationPresent(@NotNull Class<? extends Annotation> annotation) {
        return this.field.isAnnotationPresent(annotation);
    }

    @Override
    @NotNull
    public <A extends Annotation> List<A> getAnnotationsByType(@NotNull Class<A> annotation) {
        return Arrays.asList(this.field.getAnnotationsByType(annotation));
    }

    @Override
    public <A extends Annotation> A getAnnotation(@NotNull Class<A> annotation) {
        return this.field.getAnnotation(annotation);
    }

    @Override
    public TargetType getTargetType() {
        return new AnnotatedTargetType(this.field.getAnnotatedType(), this.resolver);
    }

    @Override
    @NotNull
    public AnnotatedType getAnnotatedType() {
        return this.field.getAnnotatedType();
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    @NotNull
    public String getName() {
        return this.field.getName();
    }
}

