/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnUtils;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.AnnotatedMember;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.FieldMember;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.MemberResolver;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.MethodMember;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.ReflectUtils;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.Visibility;
import com.eternalcode.formatter.libs.panda.std.Option;
import com.eternalcode.formatter.libs.panda.std.stream.PandaStream;
import com.eternalcode.formatter.libs.panda.utilities.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DefaultMemberResolver
implements MemberResolver {
    private final Visibility visibility;

    public DefaultMemberResolver(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public AnnotatedMember fromField(@NotNull Class<?> type, @NotNull Field field) {
        return new FieldMember(field, this);
    }

    @Override
    public AnnotatedMember fromProperty(@NotNull Class<?> type, @NotNull String propertyName) throws NoSuchMethodException {
        Method getter = type.getMethod("get" + propertyName, new Class[0]);
        Method setter = type.getMethod("set" + propertyName, getter.getReturnType());
        return new MethodMember(setter, getter, this);
    }

    @Override
    public List<AnnotatedMember> getFields(@NotNull Class<?> type) {
        return PandaStream.of(ReflectUtils.getAllFields(type)).map(field -> this.fromField(type, (Field)field)).toList();
    }

    @Override
    public List<AnnotatedMember> getProperties(@NotNull Class<?> type) {
        return PandaStream.of(type.getMethods()).filterNot(CdnUtils::isIgnored).map(Method::getName).filter(name -> name.startsWith("get")).map(StringUtils::capitalize).map(name -> name.substring(3)).flatMap(name -> Option.attempt(NoSuchMethodException.class, () -> this.fromProperty(type, (String)name))).toList();
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }
}

