/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.json;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.json.JsonOperators;
import com.eternalcode.formatter.libs.panda.utilities.CharacterUtils;
import com.eternalcode.formatter.libs.panda.utilities.StringUtils;
import java.util.Stack;

final class JsonToCdnConverter {
    JsonToCdnConverter() {
    }

    String enforceNewlines(String source) {
        StringBuilder result = new StringBuilder();
        Stack<Character> operators = new Stack<Character>();
        Stack<Character> sequence = new Stack<Character>();
        for (char character : source.toCharArray()) {
            if (CharacterUtils.belongsTo(character, JsonOperators.SEQUENCES)) {
                if (sequence.isEmpty()) {
                    sequence.push(Character.valueOf(character));
                } else if (((Character)sequence.peek()).charValue() == character) {
                    sequence.pop();
                }
            }
            if (sequence.isEmpty()) {
                if (CharacterUtils.belongsTo(character, JsonOperators.OPENING_OPERATORS)) {
                    operators.push(Character.valueOf(character));
                    result.append(character);
                    this.appendNewline(result, operators);
                    continue;
                }
                if (character == ':') {
                    result.append(character).append(' ');
                    continue;
                }
                if (character == ',') {
                    result.append(character);
                    this.appendNewline(result, operators);
                    continue;
                }
                if (CharacterUtils.belongsTo(character, JsonOperators.CLOSING_OPERATORS)) {
                    operators.pop();
                    this.appendNewline(result, operators);
                } else if (CharacterUtils.belongsTo(character, ' ', '\n')) {
                    if (this.lastChar(result) == character) continue;
                    if (character == '\n') {
                        this.appendNewline(result, operators);
                        continue;
                    }
                }
            }
            result.append(character);
        }
        return result.toString();
    }

    private void appendNewline(StringBuilder builder, Stack<?> indentation) {
        if (this.lastChar(builder) != '\n') {
            builder.append('\n').append(StringUtils.buildSpace(indentation.size() * 2));
        }
    }

    private char lastChar(StringBuilder builder) {
        return builder.charAt(builder.length() - 1);
    }
}

