/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.json;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnUtils;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Element;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Entry;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Piece;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Section;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.CdnModule;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.json.JsonToCdnConverter;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.shared.ArrayValueVisitor;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.standard.StandardModule;
import com.eternalcode.formatter.libs.panda.std.Blank;
import com.eternalcode.formatter.libs.panda.std.Result;
import org.jetbrains.annotations.Nullable;

public final class JsonLikeModule
extends StandardModule {
    private static final ArrayValueVisitor ARRAY_VALUE_VISITOR = new ArrayValueVisitor("", "", true);

    @Override
    public String convertToCdn(String source) {
        String standardized = source.replace("\r\n", "\n");
        return new JsonToCdnConverter().enforceNewlines(standardized);
    }

    @Override
    public Element<?> visitArrayValue(Element<?> element) {
        return ARRAY_VALUE_VISITOR.visit(element);
    }

    @Override
    public void renderDescription(StringBuilder output, String indentation, String description) {
    }

    @Override
    public void renderSectionOpening(StringBuilder output, String indentation, Section section) {
        output.append(indentation).append(CdnUtils.forceStringify(section.getName())).append(": ").append(section.getOperators()[0]).append("\n");
    }

    @Override
    public void renderSectionEnding(StringBuilder output, String indentation, @Nullable Section parent, Section section) {
        output.append(indentation).append(section.getOperators()[1]);
        if (!CdnModule.isLastElementInSection(parent, section)) {
            output.append(",");
        }
        output.append("\n");
    }

    @Override
    public Result<Blank, Exception> renderEntry(StringBuilder output, String indentation, @Nullable Section parent, Entry element) {
        output.append(indentation).append(CdnUtils.forceStringify(element.getName())).append(":").append(" ").append(CdnUtils.forceStringify(element.getPieceValue()));
        if (!CdnModule.isLastElementInSection(parent, element)) {
            output.append(",");
        }
        output.append("\n");
        return Result.ok();
    }

    @Override
    public Result<Blank, Exception> renderPiece(StringBuilder output, String indentation, @Nullable Section parent, Piece element) {
        output.append(indentation).append(CdnUtils.forceStringify(element.getValue()));
        if (!CdnModule.isLastElementInSection(parent, element)) {
            output.append(",");
        }
        output.append("\n");
        return Result.ok();
    }
}

