/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.module;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnUtils;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Element;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Entry;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Piece;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Section;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.CdnModule;
import com.eternalcode.formatter.libs.panda.std.Blank;
import com.eternalcode.formatter.libs.panda.std.Result;
import com.eternalcode.formatter.libs.panda.std.stream.PandaStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public final class Modules
implements CdnModule {
    private final List<CdnModule> modules = new ArrayList<CdnModule>();

    public boolean isEmpty() {
        return this.modules.isEmpty();
    }

    public void addModule(CdnModule module) {
        this.modules.add(module);
    }

    @Override
    public String convertToCdn(String source) {
        return CdnUtils.process(this.modules, source, CdnModule::convertToCdn);
    }

    @Override
    public void renderDescription(StringBuilder output, String indentation, String description) {
        this.modules.forEach(module -> module.renderDescription(output, indentation, description));
    }

    @Override
    public void renderSectionOpening(StringBuilder output, String indentation, Section section) {
        this.modules.forEach(module -> module.renderSectionOpening(output, indentation, section));
    }

    @Override
    public void renderSectionEnding(StringBuilder output, String indentation, @Nullable Section parent, Section section) {
        this.modules.forEach(module -> module.renderSectionEnding(output, indentation, parent, section));
    }

    @Override
    public Element<?> visitArrayValue(Element<?> element) {
        return CdnUtils.process(this.modules, element, CdnModule::visitArrayValue);
    }

    @Override
    public Element<?> resolveArrayValue(Element<?> element) {
        return CdnUtils.process(this.modules, element, CdnModule::resolveArrayValue);
    }

    @Override
    public boolean resolveArray(Stack<Section> sections, Piece value) {
        return CdnUtils.process(this.modules, false, (module, previousValue) -> previousValue != false || module.resolveArray(sections, value));
    }

    @Override
    public Result<Blank, Exception> renderEntry(StringBuilder output, String indentation, @Nullable Section parent, Entry element) {
        return PandaStream.of(this.modules).map(module -> module.renderEntry(output, indentation, parent, element)).filter(Result::isOk).head().orElseGet(Result.ok());
    }

    @Override
    public Result<Blank, Exception> renderPiece(StringBuilder output, String indentation, @Nullable Section parent, Piece element) {
        return PandaStream.of(this.modules).map(module -> module.renderPiece(output, indentation, parent, element)).filter(Result::isOk).head().orElseGet(Result.ok());
    }
}

