/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn.model;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Element;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Entry;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.standard.StandardOperators;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class Piece
implements Element<String> {
    private static final Set<Character> STRING_OPERATORS = Arrays.stream(StandardOperators.STRING_OPERATORS).map(s -> Character.valueOf(s.charAt(0))).collect(Collectors.toSet());
    private final String value;

    public Piece(String value) {
        this.value = value.trim();
    }

    public Entry toEntry(List<String> description) {
        char operator = this.value.charAt(0);
        return STRING_OPERATORS.contains(Character.valueOf(operator)) ? this.parseWithOperator(operator, description) : this.parseWithoutOperator(description);
    }

    private Entry parseWithOperator(char operator, List<String> description) {
        StringBuilder key = new StringBuilder().append(operator);
        int readIndex = 1;
        while (readIndex < this.value.length()) {
            char currentChar = this.value.charAt(readIndex++);
            key.append(currentChar);
            if (currentChar != operator) continue;
            break;
        }
        return new Entry(description, this.value, key.toString(), Piece.parseValue(this.value, readIndex));
    }

    private Entry parseWithoutOperator(List<String> description) {
        int separatorIndex = this.value.indexOf(":");
        if (separatorIndex == -1) {
            return new Entry(description, this.value, this.value, this.value);
        }
        String key = this.value.substring(0, separatorIndex).trim();
        return new Entry(description, this.value, key, Piece.parseValue(this.value, separatorIndex));
    }

    private static String parseValue(String raw, int operatorIndex) {
        String value = raw.substring(operatorIndex + ":".length());
        return value.endsWith(",") ? value.substring(0, value.length() - ",".length()).trim() : value.trim();
    }

    public String toString() {
        return "Unit { " + this.value + " }";
    }

    @Override
    public List<? extends String> getDescription() {
        return Collections.emptyList();
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

