/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnException;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnSettings;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Configuration;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Element;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Entry;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Piece;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Section;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.CdnModule;
import com.eternalcode.formatter.libs.panda.std.Blank;
import com.eternalcode.formatter.libs.panda.std.Result;
import com.eternalcode.formatter.libs.panda.utilities.StringUtils;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

final class CdnWriter {
    private final CdnSettings settings;

    CdnWriter(CdnSettings settings) {
        this.settings = settings;
    }

    public Result<String, CdnException> render(Element<?> element) {
        StringBuilder content = new StringBuilder();
        return this.render(content, 0, null, element).map(success -> {
            String result = content.toString();
            for (Map.Entry<? extends String, ? extends String> entry : this.settings.getPlaceholders().entrySet()) {
                result = StringUtils.replace(result, "${{" + entry.getKey() + "}}", entry.getValue());
            }
            return result.trim();
        }).mapErr(CdnException::new);
    }

    private Result<Blank, Exception> render(StringBuilder output, int level, @Nullable Section parent, Element<?> element) {
        String indentation = StringUtils.buildSpace(level * 2);
        CdnModule module = this.settings.getModule();
        for (String description : element.getDescription()) {
            module.renderDescription(output, indentation, description);
        }
        if (element instanceof Entry) {
            return module.renderEntry(output, indentation, parent, (Entry)element);
        }
        if (element instanceof Section) {
            Section section = (Section)element;
            boolean isRoot = section instanceof Configuration;
            if (!isRoot) {
                module.renderSectionOpening(output, indentation, section);
            }
            int subLevel = isRoot ? level : level + 1;
            for (Element sectionElement : (List)section.getValue()) {
                this.render(output, subLevel, section, sectionElement);
            }
            if (!isRoot) {
                module.renderSectionEnding(output, indentation, parent, section);
            }
            return Result.ok();
        }
        if (element instanceof Piece) {
            return module.renderPiece(output, indentation, parent, (Piece)element);
        }
        return Result.error(new IllegalStateException("Unknown element: " + element));
    }
}

