/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnSettings;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.entity.Contextual;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.entity.CustomComposer;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.entity.Exclude;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.standard.StandardOperators;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.AnnotatedMember;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.TargetType;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.reflect.Visibility;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.Composer;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.composers.ContextualComposer;
import com.eternalcode.formatter.libs.panda.std.Pair;
import com.eternalcode.formatter.libs.panda.std.Result;
import com.eternalcode.formatter.libs.panda.std.stream.PandaStream;
import com.eternalcode.formatter.libs.panda.utilities.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public final class CdnUtils {
    private static final List<Predicate<String>> LITERAL_FILTERS = Arrays.asList(value -> ObjectUtils.equalsOneOf(value, "true", "false"), value -> Result.supplyThrowing(() -> Double.parseDouble(value)).isOk());

    private CdnUtils() {
    }

    public static Result<Pair<Composer<Object>, Composer<Object>>, Exception> findPairOfComposers(CdnSettings settings, TargetType keyType, @Nullable AnnotatedMember keyMember, TargetType valueType, @Nullable AnnotatedMember valueMember) {
        return CdnUtils.findComposer(settings, keyType, keyMember).merge(CdnUtils.findComposer(settings, valueType, valueMember), Pair::of);
    }

    public static Result<Composer<Object>, Exception> findComposer(CdnSettings settings, TargetType type, @Nullable AnnotatedMember member) {
        return CdnUtils.findComposer(settings, type.getType(), type, member);
    }

    public static Result<Composer<Object>, Exception> findComposer(CdnSettings settings, Class<?> clazz, TargetType type, @Nullable AnnotatedMember member) {
        Composer<?> composer = null;
        if (member != null && member.isAnnotationPresent(CustomComposer.class)) {
            Result<Composer, ReflectiveOperationException> composerInstance = Result.attempt(ReflectiveOperationException.class, () -> {
                CustomComposer customComposer = Objects.requireNonNull(member.getAnnotation(CustomComposer.class));
                return (Composer)ObjectUtils.cast(customComposer.value().getConstructor(new Class[0]).newInstance(new Object[0]));
            });
            if (composerInstance.isErr()) {
                return Result.error((Exception)composerInstance.getError());
            }
            composer = composerInstance.get();
        } else {
            for (Map.Entry<Class<?>, Composer<?>> entry : settings.getComposers().entrySet()) {
                if (!clazz.isAssignableFrom(entry.getKey())) continue;
                composer = entry.getValue();
                break;
            }
            if (composer == null) {
                for (Map.Entry<Object, Composer<?>> entry : settings.getDynamicComposers().entrySet()) {
                    if (!((Predicate)entry.getKey()).test(clazz)) continue;
                    composer = entry.getValue();
                    break;
                }
            }
        }
        if (clazz.isAnnotationPresent(Contextual.class) || type.isAnnotationPresent(Contextual.class) || member != null && member.isAnnotationPresent(Contextual.class)) {
            composer = new ContextualComposer();
        }
        if (composer == null) {
            try {
                clazz.getMethod("getMetaClass", new Class[0]);
                return Result.error(new UnsupportedOperationException("Cannot find composer for '" + clazz + "' type. Remember that Groovy does not support @Contextual annotation in generic parameters"));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return Result.error(new UnsupportedOperationException("Cannot find composer for '" + clazz + "' type"));
            }
        }
        return Result.ok(composer);
    }

    public static Class<?> toClass(Type type) {
        if (type instanceof ParameterizedType) {
            return CdnUtils.toClass(((ParameterizedType)type).getRawType());
        }
        String typeName = type.getTypeName();
        try {
            if (typeName.contains(".")) {
                return Class.forName(type.getTypeName());
            }
            return CdnUtils.parsePrimitiveType(typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Cannot find generic type " + type);
        }
    }

    public static Class<?> parsePrimitiveType(String name) throws ClassNotFoundException {
        switch (name) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        throw new ClassNotFoundException("Unknown primitive type " + name);
    }

    public static String getPropertyNameFromMethod(String methodName) {
        methodName = methodName.substring(3);
        methodName = Character.toLowerCase(methodName.charAt(0)) + methodName.substring(1);
        return methodName;
    }

    public static boolean isIgnored(@Nullable Field field, Visibility visibility) {
        if (field == null) {
            return false;
        }
        int modifiers = field.getModifiers();
        if (!visibility.isVisible(field)) {
            return true;
        }
        if (Modifier.isStatic(modifiers)) {
            return true;
        }
        if (Modifier.isTransient(modifiers)) {
            return true;
        }
        if (field.getName().startsWith("__$") || field.getName().startsWith("$")) {
            return true;
        }
        return field.isAnnotationPresent(Exclude.class);
    }

    public static boolean isIgnored(@Nullable Method method) {
        if (method == null) {
            return false;
        }
        if (Modifier.isNative(method.getModifiers())) {
            return true;
        }
        if (method.getReturnType().getName().equals("groovy.lang.MetaClass")) {
            return true;
        }
        return method.isAnnotationPresent(Exclude.class);
    }

    public static boolean isKotlinDataClass(Class<?> clazz) {
        try {
            clazz.getMethod("component1", new Class[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String destringify(String raw) {
        if (raw.length() <= 1) {
            return raw;
        }
        String value = raw.replace("\\n", "\n");
        for (String operator : StandardOperators.STRING_OPERATORS) {
            if (!value.startsWith(operator) || !value.endsWith(operator)) continue;
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static boolean isStringified(String value) {
        for (String operator : StandardOperators.STRING_OPERATORS) {
            if (!value.startsWith(operator) || !value.endsWith(operator)) continue;
            return true;
        }
        return false;
    }

    public static String stringify(boolean enforce, String value) {
        return enforce ? CdnUtils.forceStringify(value) : value;
    }

    public static String stringify(String value) {
        String raw = value.replace("\n", "\\n");
        if (!CdnUtils.isStringified(raw) && (raw.isEmpty() || raw.trim().length() != raw.length() || raw.contains(",") || raw.contains("{") || raw.contains(":"))) {
            return CdnUtils.stringifyValue(raw);
        }
        return raw;
    }

    public static String forceStringify(String value) {
        for (Predicate<String> literalFilter : LITERAL_FILTERS) {
            if (!literalFilter.test(value)) continue;
            return value;
        }
        if (!CdnUtils.isStringified(value)) {
            return CdnUtils.stringifyValue(value);
        }
        return value;
    }

    private static String stringifyValue(String raw) {
        if (raw.contains("\"")) {
            if (raw.contains("'")) {
                if (raw.contains("`")) {
                    throw new IllegalArgumentException("Cannot stringify value: " + raw);
                }
                return "`" + raw + "`";
            }
            return "'" + raw + "'";
        }
        return "\"" + raw + "\"";
    }

    public static <K, V, E extends Exception> Map<K, V> streamOfResultPairToMap(PandaStream<Result<Pair<K, V>, E>> stream) {
        return stream.filter(Result::isOk).map(Result::get).toMapByPair(LinkedHashMap::new, pair -> pair);
    }

    public static <T, R> R process(Collection<T> processors, R value, BiFunction<T, R, R> handler) {
        for (T processor : processors) {
            value = handler.apply(processor, value);
        }
        return value;
    }

    public static <T> Function<? extends T, T> recapture() {
        return value -> value;
    }
}

