/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnException;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnExceptionInSource;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnSettings;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Array;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Configuration;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Element;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Piece;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Section;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.module.standard.StandardOperators;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.source.Source;
import com.eternalcode.formatter.libs.panda.std.Blank;
import com.eternalcode.formatter.libs.panda.std.Option;
import com.eternalcode.formatter.libs.panda.std.Result;
import com.eternalcode.formatter.libs.panda.utilities.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

final class CdnReader {
    private final CdnSettings settings;
    private final Configuration root = new Configuration();
    private final Stack<Section> sections = new Stack();
    private List<String> description = new ArrayList<String>();

    CdnReader(CdnSettings settings) {
        this.settings = settings;
    }

    public Result<Configuration, ? extends CdnException> read(Source sourceProvider) {
        String source = sourceProvider.getSource();
        source = this.settings.getModule().convertToCdn(source);
        String normalizedSource = StringUtils.replace(source.trim(), System.lineSeparator(), "\n");
        List lines = Arrays.stream(normalizedSource.split("\n")).map(String::trim).collect(Collectors.toList());
        int lineNumber = 0;
        while (lineNumber < lines.size()) {
            String originalLine = ((String)lines.get(lineNumber)).trim();
            int currentLineNumber = lineNumber++;
            Result<Blank, Exception> result = Result.attempt(() -> {
                String lineBefore;
                boolean isArray;
                String line = originalLine;
                if (line.isEmpty() || line.startsWith(StandardOperators.COMMENT_OPERATORS[0]) || line.startsWith(StandardOperators.COMMENT_OPERATORS[1])) {
                    this.description.add(line);
                    return Blank.BLANK;
                }
                if (line.endsWith(",")) {
                    line = line.substring(0, line.length() - ",".length()).trim();
                }
                if ((isArray = line.endsWith(StandardOperators.ARRAY_SEPARATOR[0])) || line.endsWith(StandardOperators.OBJECT_SEPARATOR[0])) {
                    String sectionName = this.trimSeparator(line);
                    if (sectionName.endsWith(":")) {
                        sectionName = sectionName.substring(0, sectionName.length() - ":".length()).trim();
                    }
                    Section section = isArray ? new Array(this.description, sectionName) : new Section(this.description, sectionName);
                    this.appendElement(section);
                    this.sections.push(section);
                    this.description = new ArrayList<String>();
                    return Blank.BLANK;
                }
                if (!this.sections.isEmpty() && line.endsWith(this.sections.peek().getOperators()[1]) && (lineBefore = this.trimSeparator(line)).isEmpty()) {
                    this.sections.pop();
                    return Blank.BLANK;
                }
                Piece piece = new Piece(originalLine);
                boolean isInArray = this.settings.getModule().resolveArray(this.sections, piece);
                this.appendElement(isInArray ? piece : piece.toEntry(this.description));
                this.description = new ArrayList<String>();
                return Blank.BLANK;
            });
            if (!result.isErr()) continue;
            return result.mapErr(exception -> new CdnExceptionInSource("Cannot read sources", originalLine, currentLineNumber, (Exception)exception)).projectToError();
        }
        return Result.ok(Option.when(this.root.size() == 1, this.root).flatMap(root -> root.getSection(0)).filter(element -> element.getName().isEmpty()).map(element -> new Configuration((List)element.getValue())).orElseGet(this.root));
    }

    private Element<?> appendElement(Element<?> element) {
        return this.sections.isEmpty() ? this.root.append(element) : this.sections.peek().append(element);
    }

    private String trimSeparator(String line) {
        return line.substring(0, line.length() - 1).trim();
    }
}

